/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.internal.app.services.ui;

import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.impl.ui.Messages;
import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;

public class ProjectNameValidator
implements IInputValidator {
    private IWorkspace workspace = null;
    public static final Pattern PROJECT_NAME_PATTERN = Pattern.compile("[\\p{L}\\p{N}\\._ ]+");

    public String isValid(String newText) {
        if (!PROJECT_NAME_PATTERN.matcher(newText).matches()) {
            return Messages.getString((String)"RenameProject.InvalidCharacters");
        }
        IProjectSpace projectSpace = this.workspace.getProjectSpace(newText);
        File dir = new File(this.workspace.getDirectory(), newText);
        if (projectSpace != null || dir.exists()) {
            return Messages.getString((String)"RenameProject.NameAlreadyUsed");
        }
        return null;
    }

    public ProjectNameValidator(IWorkspace workspace) {
        this.workspace = workspace;
    }
}

