/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.persistence;

import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.ui.CoreColorRegistry;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IExtReferenceResolver;
import com.modeliosoft.modelio.diagram.persistence.IInstanceFactory;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.IPersistentMigrator;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import com.modeliosoft.modelio.diagram.persistence.XmlDiagramReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDiagramReader
implements IDiagramReader {
    private Element currentDomElement = null;
    private Map<String, IPersistent> readObjects = new HashMap();
    private IPersistent rootObject = null;
    private IInstanceFactory instanceFactory;
    private IExtReferenceResolver extRefResolver;

    public XmlDiagramReader(IInstanceFactory instanceFactory, IExtReferenceResolver extRefResolver) {
        this.instanceFactory = instanceFactory;
        this.extRefResolver = extRefResolver;
    }

    public IPersistent getRoot() {
        return this.rootObject;
    }

    public Map<String, Object> readAllProperties() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        NodeList childrenNodes = this.currentDomElement.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node n = childrenNodes.item(i);
            if (n.getNodeName().equals("Property")) {
                Element attElement = (Element)n;
                String attName = attElement.getAttribute("name");
                ret.put(attName, this.readPropertyElement(attElement));
            }
            ++i;
        }
        return ret;
    }

    public void readDiagram(String data, IPersistent root) throws PersistenceException {
        this.rootObject = root;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new LocalErrorHandler(System.err));
            Document xmlDoc = db.parse(new InputSource(new StringReader(data)));
            this.currentDomElement = xmlDoc.getDocumentElement();
            String nodeId = this.currentDomElement.getAttribute("id");
            this.readObjects.put(nodeId, this.rootObject);
            this.rootObject.read((IDiagramReader)this);
        }
        catch (ParserConfigurationException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T> List<T> readListProperty(String propertyName) {
        List ret = (List)this.readProperty(propertyName);
        if (ret != null) {
            return ret;
        }
        return Collections.emptyList();
    }

    public <K, V> Map<K, V> readMapProperty(String mapName) {
        return (Map)this.readProperty(mapName);
    }

    public Object readProperty(String propertyName) {
        Element el = this.getPropertyElement(propertyName);
        if (el == null) {
            return null;
        }
        return this.readPropertyElement(el);
    }

    private AbsoluteBendpoint convertToAbsoluteBendpoint(String val) {
        String[] vals = val.split(";");
        return new AbsoluteBendpoint(Integer.valueOf(vals[0]).intValue(), Integer.valueOf(vals[1]).intValue());
    }

    private Color convertToColor(String val) {
        String[] vals = val.split(";");
        int red = Integer.valueOf(vals[0]);
        int green = Integer.valueOf(vals[1]);
        int blue = Integer.valueOf(vals[2]);
        return CoreColorRegistry.getColor((RGB)new RGB(red, green, blue));
    }

    private Dimension convertToDimension(String val) {
        String[] vals = val.split(";");
        return new Dimension(Integer.valueOf(vals[0]).intValue(), Integer.valueOf(vals[1]).intValue());
    }

    private <T extends Enum<T>> T convertToEnum(String enumType, String val) throws IllegalArgumentException, ClassNotFoundException, NullPointerException {
        return (T)this.convertToEnum(this.instanceFactory.getEnumClass(enumType), val);
    }

    private <T extends Enum<T>> T convertToEnum(Class<?> enumType, String val) throws IllegalArgumentException, NullPointerException {
        if (val == null) {
            return null;
        }
        return (T)Enum.valueOf(enumType, val);
    }

    private Font convertToFont(String val) {
        String[] vals = val.split(";");
        String name = vals[0];
        int height = Integer.valueOf(vals[1]);
        int style = Integer.valueOf(vals[2]);
        return CoreFontRegistry.getFont((FontData)new FontData(name, height, style));
    }

    private ObRef convertToObRef(String val) {
        int p = val.indexOf(" ");
        return new ObRef(val.substring(0, p), val.substring(p + 1));
    }

    private Point convertToPoint(String val) {
        String[] vals = val.split(";");
        return new Point(Integer.valueOf(vals[0]).intValue(), Integer.valueOf(vals[1]).intValue());
    }

    private Rectangle convertToRectangle(String val) {
        String[] vals = val.split(";");
        return new Rectangle(Integer.valueOf(vals[0]).intValue(), Integer.valueOf(vals[1]).intValue(), Integer.valueOf(vals[2]).intValue(), Integer.valueOf(vals[3]).intValue());
    }

    private Object createInstance(String nodeType) throws PersistenceException {
        return this.instanceFactory.createInstance(nodeType, (IDiagramReader)this);
    }

    private IPersistent getCachedObject(String objectId) {
        return (IPersistent)this.readObjects.get(objectId);
    }

    private Element getPropertyElement(String attName) {
        NodeList childrenNodes = this.currentDomElement.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Element subEl;
            Node n = childrenNodes.item(i);
            if (n.getNodeName().equals("Property") && (subEl = (Element)n).getAttribute("name").equals(attName)) {
                return subEl;
            }
            ++i;
        }
        return null;
    }

    private IPersistent readExtRef(Element domElement) throws PersistenceException {
        String nodeType = domElement.getAttribute("type");
        String extDbId = domElement.getAttribute("extDbId");
        String extRefId = domElement.getAttribute("extId");
        String nodeId = domElement.getAttribute("id");
        Element oldCurrentDomElement = this.currentDomElement;
        this.currentDomElement = domElement;
        try {
            IPersistent ret = this.extRefResolver.resolveReference(nodeType, extDbId, extRefId);
            if (ret != null && nodeId != null && !nodeId.isEmpty()) {
                this.readObjects.put(nodeId, ret);
            }
            IPersistent iPersistent = ret;
            return iPersistent;
        }
        finally {
            this.currentDomElement = oldCurrentDomElement;
        }
    }

    private <T> List<T> readListElement(Element subEl) throws PersistenceException {
        NodeList compNodes2 = subEl.getChildNodes();
        ArrayList<Object> ret = new ArrayList<Object>(compNodes2.getLength());
        int i2 = 0;
        while (i2 < compNodes2.getLength()) {
            Node compNode = compNodes2.item(i2);
            if (compNode instanceof Element) {
                Element compElement = (Element)compNode;
                ret.add(this.readObjectElement(compElement));
            }
            ++i2;
        }
        return ret;
    }

    private <K, V> Map<K, V> readMapElement(Element domElement) throws PersistenceException {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        NodeList childrenNodes = domElement.getChildNodes();
        Object entryKey = null;
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node n = childrenNodes.item(i);
            if (n instanceof Element) {
                Element mapElement = (Element)n;
                Object o = this.readObjectElement(mapElement);
                if (entryKey == null) {
                    entryKey = o;
                } else {
                    ret.put(entryKey, o);
                    entryKey = null;
                }
            }
            ++i;
        }
        return ret;
    }

    private Object readObjectElement(Element compElement) throws PersistenceException {
        String tagName = compElement.getTagName();
        if (tagName.equals("Object")) {
            return this.readPersistentElement(compElement);
        }
        if (tagName.equals("Ref")) {
            return this.readObjectRef(compElement);
        }
        if (tagName.equals("ExtRef")) {
            return this.readExtRef(compElement);
        }
        if (tagName.equals("Value")) {
            return this.readValueElement(compElement);
        }
        if (tagName.equals("List")) {
            return this.readListElement(compElement);
        }
        if (tagName.equals("Map")) {
            return this.readMapElement(compElement);
        }
        throw new RuntimeException("<" + tagName + "> tag not handled.");
    }

    private IPersistent readObjectRef(Element compNode) {
        String objectId = compNode.getAttribute("id");
        return this.getCachedObject(objectId);
    }

    private IPersistent readPersistentElement(Element domElement) throws PersistenceException {
        String nodeType = domElement.getAttribute("type");
        String majorVersionAtt = domElement.getAttribute("major_version");
        int majorVersionRead = majorVersionAtt.equals("") ? 0 : Integer.parseInt(majorVersionAtt);
        String nodeId = domElement.getAttribute("id");
        Element oldCurrentDomElement = this.currentDomElement;
        this.currentDomElement = domElement;
        try {
            IPersistent persistentObject = (IPersistent)this.createInstance(nodeType);
            if (persistentObject.getMajorVersion() == majorVersionRead) {
                persistentObject.read((IDiagramReader)this);
                this.readObjects.put(nodeId, persistentObject);
            } else {
                String migratorType = String.valueOf(nodeType) + "Migrator";
                IPersistentMigrator migrator = (IPersistentMigrator)this.createInstance(migratorType);
                persistentObject = migrator.createInstanceOfMajorVersion(majorVersionRead);
                persistentObject.read((IDiagramReader)this);
                persistentObject = migrator.migrate(persistentObject);
                this.readObjects.put(nodeId, persistentObject);
            }
            IPersistent iPersistent = persistentObject;
            return iPersistent;
        }
        finally {
            this.currentDomElement = oldCurrentDomElement;
        }
    }

    private Object readPropertyElement(Element el) throws PersistenceException {
        NodeList childrenNodes = el.getChildNodes();
        int i = 0;
        while (i < childrenNodes.getLength()) {
            Node n = childrenNodes.item(i);
            if (n instanceof Element) {
                Element subEl = (Element)n;
                return this.readObjectElement(subEl);
            }
            ++i;
        }
        return null;
    }

    private Object readValueElement(Element el) throws NumberFormatException, PersistenceException {
        String type = el.getAttribute("type");
        String val = el.getAttribute("value");
        if (type.equals("null")) {
            return null;
        }
        if (type.equals("Rectangle")) {
            return this.convertToRectangle(val);
        }
        if (type.equals("Point")) {
            return this.convertToPoint(val);
        }
        if (type.equals("Dimension")) {
            return this.convertToDimension(val);
        }
        if (type.equals("AbsoluteBendpoint")) {
            return this.convertToAbsoluteBendpoint(val);
        }
        if (type.equals("String")) {
            return val;
        }
        if (type.equals("Integer")) {
            return Integer.valueOf(val);
        }
        if (type.equals("Color")) {
            return this.convertToColor(val);
        }
        if (type.equals("Font")) {
            return this.convertToFont(val);
        }
        if (type.equals("Boolean")) {
            return Boolean.parseBoolean(val);
        }
        if (type.equals("Double")) {
            return Double.parseDouble(val);
        }
        if (type.equals("Float")) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (type.equals("ObRef")) {
            return this.convertToObRef(val);
        }
        if (type.startsWith("Enum:")) {
            String enumType = type.substring(type.indexOf(":") + 1);
            try {
                return this.convertToEnum(enumType, val);
            }
            catch (Exception e) {
                throw new PersistenceException("Couldn't read '" + val + "' value of " + type + " type: " + e.getLocalizedMessage(), e);
            }
        }
        throw new PersistenceException("'" + val + "' of " + type + " type is not handled.");
    }
}

