/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.persistence;

import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class XmlDiagramWriter
implements IDiagramWriter {
    private StringWriter result = new StringWriter();
    private XMLStreamWriter writer;
    private IPersistent root;
    private Map<IPersistent, String> writtenObjects = new HashMap();

    public XmlDiagramWriter() throws PersistenceException {
        XMLOutputFactory f = XMLOutputFactory.newInstance();
        try {
            this.writer = f.createXMLStreamWriter(this.result);
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public String getOutput() {
        return this.result.toString();
    }

    public IPersistent getRoot() {
        return this.root;
    }

    public void save(IPersistent rootElement) throws PersistenceException {
        this.root = rootElement;
        try {
            this.writer.writeStartDocument();
            this.writePersistentObject(rootElement);
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void writeValue(Enum<?> e) {
        this.writeValueTag("Enum:" + e.getClass().getName(), e.toString());
    }

    private void writeValue(Float value) {
        this.writeValueTag("Float", value.toString());
    }

    private void writeValue(AbsoluteBendpoint value) throws PersistenceException {
        String v = String.valueOf(value.x) + ";" + value.y;
        this.writeValueTag("AbsoluteBendpoint", v);
    }

    private void writeValue(String value) throws PersistenceException {
        this.writeValueTag("String", value);
    }

    private void writeValue(Boolean value) {
        this.writeValueTag("Boolean", value.toString());
    }

    private void writeValue(Double value) {
        this.writeValueTag("Double", value.toString());
    }

    private void writeValue(int value) throws PersistenceException {
        this.writeValueTag("Integer", String.valueOf(value));
    }

    private void writeValue(ObRef value) throws PersistenceException {
        this.writeValueTag("ObRef", String.valueOf(value.mc) + " " + value.uuid);
    }

    private void writeValue(Rectangle value) throws PersistenceException {
        String v = String.valueOf(value.x) + ";" + value.y + ";" + value.width + ";" + value.height;
        this.writeValueTag("Rectangle", v);
    }

    private void writeValue(Point value) throws PersistenceException {
        String v = String.valueOf(value.x) + ";" + value.y;
        this.writeValueTag("Point", v);
    }

    public void writeExtRef(IPersistent extObj, String dbId, String refId) throws PersistenceException {
        try {
            this.writer.writeEmptyElement("ExtRef");
            this.writer.writeAttribute("type", extObj.getClass().getName());
            this.writer.writeAttribute("extDbId", dbId);
            this.writer.writeAttribute("extId", refId);
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private <V> void writeList(List<V> list) throws PersistenceException {
        try {
            this.writer.writeStartElement("List");
            for (V v : list) {
                this.writeObjectValue(v);
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private <K, V> void writeMap(Map<K, V> map) {
        try {
            this.writer.writeStartElement("Map");
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.writeObjectValue(e.getKey());
                this.writeObjectValue(e.getValue());
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Object value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeObjectValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private String getId(IPersistent i) {
        return (String)this.writtenObjects.get(i);
    }

    private String putId(IPersistent i) {
        String ret = String.valueOf(this.writtenObjects.size() + 1);
        this.writtenObjects.put(i, ret);
        return ret;
    }

    private void writeValue(Color value) {
        String s = String.valueOf(String.valueOf(value.getRed())) + ";" + String.valueOf(value.getGreen()) + ";" + String.valueOf(value.getBlue());
        this.writeValueTag("Color", s);
    }

    private void writeValue(Font value) {
        FontData fontData = value.getFontData()[0];
        String s = String.valueOf(fontData.getName()) + ";" + String.valueOf(fontData.getHeight()) + ";" + String.valueOf(fontData.getStyle());
        this.writeValueTag("Font", s);
    }

    private void writeExternalRef(IPersistent c) {
        c.write((IDiagramWriter)this);
    }

    public <V> void writeProperty(String attName, List<V> value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeList(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <K, V> void writeProperty(String attName, Map<K, V> value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeMap(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void writePersistentObject(IPersistent i) throws XMLStreamException {
        String objId = this.putId(i);
        this.writer.writeStartElement("Object");
        this.writer.writeAttribute("id", objId);
        this.writer.writeAttribute("type", i.getClass().getName());
        this.writer.writeAttribute("major_version", Integer.toString(i.getMajorVersion()));
        i.write((IDiagramWriter)this);
        this.writer.writeEndElement();
    }

    private void writeRef(IPersistent i) throws XMLStreamException {
        this.writer.writeEmptyElement("Ref");
        this.writer.writeAttribute("id", this.getId(i));
    }

    private void writeObjectValue(Object value) throws PersistenceException {
        if (value == null) {
            this.writeValueTag("null", null);
        } else {
            Class<?> c = value.getClass();
            if (c == Integer.class) {
                this.writeValue(((Integer)value).intValue());
            } else if (c == String.class) {
                this.writeValue((String)value);
            } else if (c == Rectangle.class) {
                this.writeValue((Rectangle)value);
            } else if (c == Point.class) {
                this.writeValue((Point)value);
            } else if (c == AbsoluteBendpoint.class) {
                this.writeValue((AbsoluteBendpoint)value);
            } else if (c == Color.class) {
                this.writeValue((Color)value);
            } else if (c == Boolean.class) {
                this.writeValue((Boolean)value);
            } else if (c == Double.class) {
                this.writeValue((Double)value);
            } else if (c == Float.class) {
                this.writeValue((Float)value);
            } else if (c == ObRef.class) {
                this.writeValue((ObRef)value);
            } else if (c == Font.class) {
                this.writeValue((Font)value);
            } else if (c == Dimension.class) {
                this.writeValue((Dimension)value);
            } else if (value instanceof Enum) {
                this.writeValue((Enum)value);
            } else if (value instanceof List) {
                this.writeList((List)value);
            } else if (value instanceof Map) {
                this.writeMap((Map)value);
            } else if (value instanceof IPersistent) {
                this.writePersistentValue((IPersistent)value);
            } else {
                throw new IllegalArgumentException(String.valueOf(c.getSimpleName()) + " is not handled.");
            }
        }
    }

    private void writePersistentValue(IPersistent c) {
        try {
            if (c == null) {
                this.writeValueTag("null", null);
            } else if (c.isExternal((IDiagramWriter)this)) {
                this.writeExternalRef(c);
            } else if (this.writtenObjects.containsKey(c)) {
                this.writeRef(c);
            } else {
                this.writePersistentObject(c);
            }
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, AbsoluteBendpoint value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Boolean value) {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Double value) {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Enum<?> value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Float value) {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, int value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, IPersistent value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writePersistentValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, ObRef obRef) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(obRef);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Point value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Rectangle value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, String value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void writeValueTag(String type, String value) throws PersistenceException {
        try {
            this.writer.writeEmptyElement("Value");
            this.writer.writeAttribute("type", type);
            if (value != null) {
                this.writer.writeAttribute("value", value);
            }
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void writeProperty(String attName, Dimension value) throws PersistenceException {
        try {
            this.writer.writeStartElement("Property");
            this.writer.writeAttribute("name", attName);
            this.writeValue(value);
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void writeValue(Dimension value) {
        String v = String.valueOf(value.width) + ";" + value.height;
        this.writeValueTag("Dimension", v);
    }
}

