/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.communication.elements.communicationmessage;

import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationChannel;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationMessage;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.communication.elements.communicationmessage.GmCommunicationMessageLabel;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.GmInfoFlowsGroup;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import java.util.List;

public final class GmCommunicationSentMessageGroup
extends GmGroup {
    private ICommunicationChannel relatedEl;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmCommunicationSentMessageGroup(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.relatedEl = (ICommunicationChannel)this.resolveRef(relatedRef);
    }

    public GmCommunicationSentMessageGroup() {
    }

    public final boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return GmCommunicationMessageLabel.class.isAssignableFrom(nodeClass);
    }

    public final boolean canCreate(Class<? extends IElement> type) {
        return ICommunicationMessage.class.isAssignableFrom(type);
    }

    public IElement getRelatedIElement() {
        return this.relatedEl;
    }

    public final boolean isVisible() {
        return true;
    }

    public void obElementsUpdated() {
        this.refreshFromObModel();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmCommunicationSentMessageGroup.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public final void refreshFromObModel() {
        super.refreshFromObModel();
        IElement related = this.getRelatedIElement();
        if (related != null && related.isValid()) {
            List oldChildren = this.getChildren();
            for (ICommunicationMessage part : this.relatedEl.getSentMessage()) {
                ObRef msgRef = new ObRef((IElement)part);
                GmNodeModel gmMessageLabel = this.getNode(oldChildren, GmCommunicationMessageLabel.class, msgRef);
                if (gmMessageLabel == null) {
                    gmMessageLabel = this.getDiagram().unmask((GmCompositeNode)this, (IElement)part, null);
                }
                GmInfoFlowsGroup flowGroup = (GmInfoFlowsGroup)this.getNode(oldChildren, GmInfoFlowsGroup.class, msgRef);
                if (part.cardRealizedInformationFlow() > 0) {
                    if (flowGroup != null) continue;
                    flowGroup = new GmInfoFlowsGroup(this.getDiagram(), msgRef);
                    this.addChild((GmNodeModel)flowGroup, this.getChildIndex(gmMessageLabel) + 1);
                    continue;
                }
                if (flowGroup == null) continue;
                flowGroup.delete();
            }
        }
    }

    public final void styleChanged(IStyle style) {
        this.refreshFromObModel();
        this.fireVisibilityChanged();
        super.styleChanged(style);
    }

    protected void doSetVisible(boolean visible) {
    }

    protected final boolean isValidElement(IElement el) {
        if (!(el instanceof ICommunicationMessage) || !el.isValid()) {
            return false;
        }
        return this.relatedEl.getSentMessage().contains((Object)el);
    }

    protected final void updateHiddenFeatures() {
        this.setHiddenFeature(false);
    }

    private GmNodeModel getNode(List<GmNodeModel> oldChildren, Class<?> cl, ObRef relatedRef) {
        for (GmNodeModel c : oldChildren) {
            if (!cl.isInstance(c) || !c.getRepresentedRef().equals((Object)relatedRef)) continue;
            return c;
        }
        return null;
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmCommunicationSentMessageGroup.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.relatedEl = (ICommunicationChannel)this.resolveRef((ObRef)in.readProperty("relatedRef"));
    }

    public int getMajorVersion() {
        return 0;
    }
}

