/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.commands;

import com.modeliosoft.modelio.api.model.extension.IConfigParam;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.explorer.popup.model.AbstractCreateAction;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDialog;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeMessageDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateStereotypeAction
extends AbstractCreateAction {
    public void execute(List<IElement> selectedElements) {
        MdaExplorerView view;
        ArrayList<IModelElement> parentElements = new ArrayList<IModelElement>();
        for (IElement selectedElement : selectedElements) {
            if (!(selectedElement instanceof IModelElement)) continue;
            parentElements.add((IModelElement)selectedElement);
        }
        IStereotype createdStereotype = null;
        if (parentElements.size() > 0) {
            O.getDefault().getPickingProviderService().abortPicking();
            IElement parentElement = selectedElements.get(0);
            StereotypeCreationDataModel dataModel = this.promptUser(parentElements, false);
            if (dataModel != null && parentElement instanceof IProfile) {
                createdStereotype = this.createStereotype((IProfile)parentElement, dataModel);
            }
        }
        if (createdStereotype != null && (view = this.getMdaExplorerView()) != null) {
            view.selectElement(createdStereotype);
        }
    }

    public boolean isActiveFor(List<IElement> selectedElements) {
        return selectedElements.size() == 1;
    }

    public boolean accept(List<IElement> selectedElements) {
        return true;
    }

    protected MdaExplorerView getMdaExplorerView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof MdaExplorerView) {
            return (MdaExplorerView)activePart;
        }
        return null;
    }

    private StereotypeCreationDataModel promptUser(List<IModelElement> elements, boolean showApplyStereotype) {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IModelElement element = null;
        if (elements.size() > 0) {
            element = elements.get(0);
        }
        String metaclassName = null;
        metaclassName = element == null || element instanceof IModule || element instanceof IProfile || element instanceof IProject || element instanceof ITagType || element instanceof INoteType || element instanceof IStereotype || element instanceof IConfigParam ? "ModelElement" : element.getMetaclassName();
        StereotypeCreationDataModel dataModel = new StereotypeCreationDataModel(metaclassName, null);
        dataModel.setApplyStereotype(showApplyStereotype);
        StereotypeCreationDialog dialog = new StereotypeCreationDialog(parentShell, dataModel);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private IStereotype createStereotype(IProfile selectedElement, StereotypeCreationDataModel dataModel) {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IModelFactory factory = modelingSession.getModelFactory();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Create Stereotype");
        IStereotype theStereotype = null;
        try {
            theStereotype = factory.createStereotype();
            theStereotype.setName(dataModel.getStereotypeName());
            theStereotype.setLabel(dataModel.getStereotypeName());
            theStereotype.setBaseClassName(dataModel.getMetaclassName());
            IModule module = this.getOwnerModule(selectedElement);
            if (module != null) {
                this.setIconsPathes(dataModel, theStereotype, module);
            }
            selectedElement.addDefinedStereotype(theStereotype);
            transactionManager.commit(transaction);
            transaction = null;
            IStereotype iStereotype = theStereotype;
            return iStereotype;
        }
        catch (InvalidTransactionException e) {
            transaction = null;
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return theStereotype;
    }

    private File copy(File in, File out) throws IOException {
        if (!in.equals(out)) {
            FileChannel inChannel = new FileInputStream(in).getChannel();
            FileChannel outChannel = new FileOutputStream(out).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        return out;
    }

    private void setIconsPathes(StereotypeCreationDataModel dataModel, IStereotype stereotype, IModule module) {
        String explorerIconPath = dataModel.getExplorerIcon();
        String diagramImagePath = dataModel.getDiagramImage();
        File explorerIconFile = new File(explorerIconPath);
        File diagramImageFile = new File(diagramImagePath);
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        String projectPath = modelingSession.getProjectSpacePath().getPath();
        File projectDirectory = new File(projectPath);
        File destinationDirectory = new File(projectDirectory, "/mda/" + module.getName() + "/res/bmp");
        HashSet<File> filesToCopy = new HashSet<File>();
        if (explorerIconFile.exists() && !explorerIconFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(explorerIconFile);
        }
        if (diagramImageFile.exists() && !diagramImageFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(diagramImageFile);
        }
        boolean copyFiles = true;
        StringBuffer filesAlreadyExistsMsg = new StringBuffer();
        HashSet<File> filesAlreadyExists = new HashSet<File>();
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            if (!destinationFile.exists()) continue;
            filesAlreadyExists.add(file);
            filesAlreadyExistsMsg.append("- ");
            filesAlreadyExistsMsg.append(destinationFile.getAbsolutePath());
            filesAlreadyExistsMsg.append(Text.DELIMITER);
        }
        if (filesAlreadyExistsMsg.length() > 0 && !(copyFiles = StereotypeMessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.FileAlreadyExists.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.FileAlreadyExists.Message", new String[]{filesAlreadyExistsMsg.toString(), destinationDirectory.getAbsolutePath()})))) {
            for (File filesAlreadyExist : filesAlreadyExists) {
                filesToCopy.remove(filesAlreadyExist);
            }
        }
        TreeMap<File, IOException> copyErrors = new TreeMap<File, IOException>();
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            try {
                this.copy(file, destinationFile);
            }
            catch (IOException e) {
                LOG.warning((String)"org.modelio.mda.explorer", (Throwable)e);
                copyErrors.put(file, e);
            }
        }
        if (!copyErrors.isEmpty()) {
            StringBuffer filesErrorsMsg = new StringBuffer();
            for (Map.Entry err : copyErrors.entrySet()) {
                filesErrorsMsg.append("- ");
                filesErrorsMsg.append(((File)err.getKey()).getAbsolutePath());
                filesErrorsMsg.append(": ");
                filesErrorsMsg.append(((IOException)err.getValue()).getLocalizedMessage());
                filesErrorsMsg.append(Text.DELIMITER);
            }
            StereotypeMessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.IOException.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.IOException.Message", new String[]{filesErrorsMsg.toString()}));
        }
        if (explorerIconFile.isFile()) {
            stereotype.setIconBrowser(String.valueOf(module.getName()) + "/res/bmp/" + explorerIconFile.getName());
        }
        if (diagramImageFile.isFile()) {
            stereotype.setIcon(String.valueOf(module.getName()) + "/res/bmp/" + diagramImageFile.getName());
        }
    }

    private IModule getOwnerModule(IProfile profile) {
        IModule module = profile.getOwnerModule();
        if (module != null) {
            return module;
        }
        IModelTree ownerElement = profile.getOwner();
        if (ownerElement instanceof IProfile) {
            return this.getOwnerModule((IProfile)ownerElement);
        }
        return null;
    }
}

