/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.commands;

import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.explorer.popup.model.AbstractCreateAction;
import com.modeliosoft.modelio.explorer.popup.model.MissingCreateAction;
import com.modeliosoft.modelio.mda.explorer.commands.CommandModel;
import com.modeliosoft.modelio.mda.explorer.commands.ItemModel;
import com.modeliosoft.modelio.mda.explorer.commands.MenuModel;
import com.modeliosoft.modelio.mda.explorer.commands.SeparatorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MdaContextMenuModel {
    protected Map<String, List<ItemModel>> itemsMetaclassMap = new HashMap();
    private ResourceBundle propertiesBundle = ResourceBundle.getBundle("explorer-create-menus");
    private Map<String, AbstractCreateAction> actions;

    public void loadXML() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.mda.explorer");
        Path explorerContextualMenu = new Path("/res/explorer-create-menus.xml");
        URL url = FileLocator.find((Bundle)bundle, (IPath)explorerContextualMenu, null);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream xmlStream = url.openStream();
            Document xmlDoc = db.parse(xmlStream);
            Element rootElement = xmlDoc.getDocumentElement();
            this.loadMenusAndCommands(rootElement);
            xmlStream.close();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadMenusAndCommands(Element element) {
        Node node;
        NodeList mdacNodes = element.getChildNodes();
        this.actions = new HashMap();
        int commandNb = mdacNodes.getLength();
        int i = 0;
        while (i < commandNb) {
            AbstractCreateAction action;
            node = mdacNodes.item(i);
            if (node.getNodeName().equals("command") && (action = this.loadAction(node)) != null) {
                this.actions.put(action.getId(), action);
            }
            ++i;
        }
        i = 0;
        while (i < commandNb) {
            node = mdacNodes.item(i);
            if (node.getNodeName().equals("popup-menu")) {
                this.loadPopupMenu(node, this.actions);
            }
            ++i;
        }
    }

    private AbstractCreateAction loadAction(Node commandNode) {
        NamedNodeMap commandAttributes = commandNode.getAttributes();
        String id = null;
        String targetClass = null;
        String role = null;
        String stereotype = null;
        String handler = null;
        if (commandAttributes != null) {
            String symbolicName;
            String tooltip;
            String label;
            Node idNode = commandAttributes.getNamedItem("id");
            Node targetClassNode = commandAttributes.getNamedItem("target");
            Node roleNode = commandAttributes.getNamedItem("dep");
            Node StereotypeNode = commandAttributes.getNamedItem("stereotype");
            Node handlerNode = commandAttributes.getNamedItem("handler");
            if (idNode != null) {
                id = idNode.getTextContent();
            }
            if (targetClassNode != null) {
                targetClass = targetClassNode.getTextContent();
            }
            if (roleNode != null) {
                role = roleNode.getTextContent();
            }
            if (StereotypeNode != null) {
                stereotype = StereotypeNode.getTextContent();
            }
            if (handlerNode != null) {
                handler = handlerNode.getTextContent();
            }
            String labelId = String.valueOf(id) + ".label";
            String tooltipId = String.valueOf(id) + ".tooltip";
            String bitmapId = String.valueOf(id) + ".bitmap";
            try {
                label = this.propertiesBundle.getString(labelId);
            }
            catch (MissingResourceException e) {
                label = labelId;
            }
            try {
                tooltip = this.propertiesBundle.getString(tooltipId);
            }
            catch (MissingResourceException e) {
                tooltip = tooltipId;
            }
            try {
                symbolicName = this.propertiesBundle.getString(bitmapId);
            }
            catch (MissingResourceException e) {
                symbolicName = bitmapId;
            }
            ImageDescriptor image = null;
            if (!symbolicName.equals("")) {
                image = StandardImageService.getImageDescriptor((String)symbolicName);
            }
            AbstractCreateAction action = this.createHandler(handler);
            action.setTargetClass(targetClass);
            action.setRole(role);
            action.setStereotype(stereotype);
            action.setId(id);
            action.setText(label);
            action.setToolTipText(tooltip);
            if (image != null) {
                action.setImageDescriptor(image);
            }
            return action;
        }
        return null;
    }

    private void loadPopupMenu(Node menusNode, Map<String, AbstractCreateAction> actionsMap) {
        Node metaclassNode;
        NamedNodeMap attributes = menusNode.getAttributes();
        String metaclassName = "";
        if (attributes != null && (metaclassNode = attributes.getNamedItem("metaclass")) != null) {
            metaclassName = metaclassNode.getTextContent();
        }
        ArrayList entriesList = new ArrayList();
        this.itemsMetaclassMap.put(metaclassName, entriesList);
        NodeList menusNodes = menusNode.getChildNodes();
        int menusNodesNb = menusNodes.getLength();
        int i = 0;
        while (i < menusNodesNb) {
            Node node = menusNodes.item(i);
            if (node.getNodeName().equals("item")) {
                this.loadItem(node, entriesList, actionsMap);
            } else if (node.getNodeName().equals("menu")) {
                this.loadMenu(node, entriesList, actionsMap);
            } else if (node.getNodeName().equals("separator")) {
                this.loadSeparator(node, entriesList);
            }
            ++i;
        }
    }

    private void loadItem(Node itemNode, List<ItemModel> entries, Map<String, AbstractCreateAction> actionsMap) {
        CommandModel item = this.getItem(itemNode, actionsMap);
        if (item != null) {
            entries.add((ItemModel)item);
        }
    }

    private void loadMenu(Node menuNode, List<ItemModel> entries, Map<String, AbstractCreateAction> actionsMap) {
        MenuModel menu = this.getMenu(menuNode);
        if (menu != null) {
            entries.add((ItemModel)menu);
            NodeList subMenusNodes = menuNode.getChildNodes();
            int i = 0;
            while (i < subMenusNodes.getLength()) {
                Node node = subMenusNodes.item(i);
                if (node.getNodeName().equals("item")) {
                    this.loadItem(node, menu, actionsMap);
                } else if (node.getNodeName().equals("menu")) {
                    this.loadMenu(node, menu, actionsMap);
                } else if (node.getNodeName().equals("separator")) {
                    this.loadSeparator(node, menu);
                }
                ++i;
            }
        }
    }

    public MdaContextMenuModel() {
        this.loadXML();
    }

    private CommandModel getItem(Node itemNode, Map<String, AbstractCreateAction> actionsMap) {
        Node commandIdNode;
        NamedNodeMap itemAttributes = itemNode.getAttributes();
        String commandId = "";
        if (itemAttributes != null && (commandIdNode = itemAttributes.getNamedItem("commandId")) != null) {
            commandId = commandIdNode.getTextContent();
        }
        CommandModel item = new CommandModel(actionsMap.get(commandId));
        return item;
    }

    private MenuModel getMenu(Node menuNode) {
        Node idNode;
        NamedNodeMap menuAttributes = menuNode.getAttributes();
        String id = "";
        if (menuAttributes != null && (idNode = menuAttributes.getNamedItem("id")) != null) {
            id = idNode.getTextContent();
        }
        if (id != null && !id.equals("")) {
            String bitmap;
            String label;
            String labelId = String.valueOf(id) + ".label";
            String bitmapId = String.valueOf(id) + ".bitmap";
            try {
                label = this.propertiesBundle.getString(labelId);
            }
            catch (MissingResourceException e) {
                label = labelId;
            }
            try {
                bitmap = this.propertiesBundle.getString(bitmapId);
            }
            catch (MissingResourceException e) {
                bitmap = "";
            }
            ImageDescriptor image = null;
            if (!bitmap.equals("")) {
                Bundle imageBundle = Platform.getBundle((String)"org.modelio.mda.explorer");
                Path bitmapPath = new Path(bitmap);
                URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
                image = ImageDescriptor.createFromURL((URL)bitmapUrl);
            }
            MenuModel subMenu = new MenuModel(label, id, image);
            return subMenu;
        }
        return null;
    }

    private void loadItem(Node itemNode, MenuModel menu, Map<String, AbstractCreateAction> actionsMap) {
        CommandModel command = this.getItem(itemNode, actionsMap);
        if (command != null) {
            menu.add((ItemModel)command);
        }
    }

    private void loadMenu(Node menuNode, MenuModel menu, Map<String, AbstractCreateAction> actionsMap) {
        MenuModel subMenu = this.getMenu(menuNode);
        if (subMenu != null) {
            menu.add((ItemModel)subMenu);
            NodeList subMenusNodes = menuNode.getChildNodes();
            int i = 0;
            while (i < subMenusNodes.getLength()) {
                Node node = subMenusNodes.item(i);
                if (node.getNodeName().equals("item")) {
                    this.loadItem(node, subMenu, actionsMap);
                } else if (node.getNodeName().equals("menu")) {
                    this.loadMenu(node, subMenu, actionsMap);
                }
                ++i;
            }
        }
    }

    public List<ItemModel> getItems(String metaclass) {
        List theActions = (List)this.itemsMetaclassMap.get(metaclass);
        if (theActions != null) {
            return theActions;
        }
        return new ArrayList<ItemModel>();
    }

    private AbstractCreateAction createHandler(String handlerName) {
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> handlerClass = null;
        MissingCreateAction handler = null;
        if (handlerName == null) {
            throw new NullPointerException();
        }
        try {
            handlerClass = loader.loadClass(handlerName);
            handler = (AbstractCreateAction)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e1) {
            handler = new MissingCreateAction();
        }
        catch (InstantiationException e) {
            handler = new MissingCreateAction();
        }
        catch (IllegalAccessException e) {
            handler = new MissingCreateAction();
        }
        catch (IllegalArgumentException e) {
            handler = new MissingCreateAction();
        }
        catch (SecurityException e) {
            handler = new MissingCreateAction();
        }
        return handler;
    }

    private void loadSeparator(Node separatorNode, List<ItemModel> entries) {
        SeparatorModel separator = this.createSeparator(separatorNode);
        entries.add((ItemModel)separator);
    }

    private SeparatorModel createSeparator(Node separatorNode) {
        Node commandIdNode;
        NamedNodeMap itemAttributes = separatorNode.getAttributes();
        String id = "";
        if (itemAttributes != null && (commandIdNode = itemAttributes.getNamedItem("id")) != null) {
            id = commandIdNode.getTextContent();
        }
        SeparatorModel model = new SeparatorModel(id);
        return model;
    }

    private void loadSeparator(Node separatorNode, MenuModel menu) {
        SeparatorModel separator = this.createSeparator(separatorNode);
        menu.add((ItemModel)separator);
    }

    public IAction getAction(String commandId) {
        return (IAction)this.actions.get(commandId);
    }

    public Map<String, List<ItemModel>> getItemsMetaclassMap() {
        return this.itemsMetaclassMap;
    }

    public ResourceBundle getPropertiesBundle() {
        return this.propertiesBundle;
    }

    public Map<String, AbstractCreateAction> getActions() {
        return this.actions;
    }
}

