/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.explorer.popup.model.AbstractCreateAction;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MdaCreatePrimitiveGeneralClassAction
extends AbstractCreateAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(List<IElement> selectedElements) {
        IElement parentElement = selectedElements.get(0);
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        if (modelingSession == null) return;
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Create a " + this.targetClass);
        try {
            try {
                IElement element = modelingSession.getModelFactory().createElement(this.targetClass, parentElement, this.role);
                if (element instanceof IGeneralClass) {
                    IGeneralClass generalClass = (IGeneralClass)element;
                    generalClass.setElementary(true);
                    if (this.stereotype != null) {
                        IStereotype obstereotype = modelingSession.getModel().getProject().getStereotype(element.getClass(), this.stereotype);
                        generalClass.addExtension(obstereotype);
                    }
                    DefaultNameFactory.setDefaultName((IModelElement)generalClass);
                }
                transactionManager.commit(transaction);
                transaction = null;
                MdaExplorerView view = this.getMdaView();
                if (view == null) return;
                view.selectElement(element);
                ModelElementAdapter adapter = view.getContentProvider().getAdaptersCache().getAdapter(element);
                view.getCommonViewer().editElement((Object)adapter, 0);
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (StereotypeNotFoundException e) {
                LOG.error((String)"org.modelio.mda.explorer", (Throwable)e);
                this.reportException((Exception)((Object)e));
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    public boolean isActiveFor(List<IElement> selectedElements) {
        return selectedElements.size() == 1;
    }

    public boolean accept(List<IElement> selectedElements) {
        return true;
    }

    protected MdaExplorerView getMdaView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof MdaExplorerView) {
            return (MdaExplorerView)activePart;
        }
        return null;
    }

    void reportException(Exception e) {
        MessageDialog.openError(null, (String)"Error", (String)e.getLocalizedMessage());
    }
}

