/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.commands;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.explorer.model.DependencyContainerAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MdaCutElementAction
extends Action {
    boolean ctrlFlag;
    public static final String ACTION_ID = "com.modeliosoft.modelio.mda.CutElementCommandID";
    private Clipboard clipboard;

    public MdaCutElementAction() {
        this.setActionDefinitionId(ACTION_ID);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof Tree || event.widget instanceof MenuItem) {
            List selectedElements = this.getSelectedElements();
            PasteElementObject toCopy = new PasteElementObject(PasteElementObject.PasteType.CUT);
            for (IElement element : selectedElements) {
                toCopy.addTransferedItems(new TransferItem(element, element.getCompositionOwner()));
            }
            this.clipboard.setContents(new Object[]{toCopy}, new Transfer[]{PasteElementTransfer.getInstance()});
        } else if (event.widget instanceof Text) {
            Text text = (Text)event.widget;
            text.cut();
        }
    }

    public MdaCutElementAction(String text, ImageDescriptor image, Clipboard clipboard) {
        super(text, image);
        this.clipboard = clipboard;
        this.ctrlFlag = false;
    }

    public MdaCutElementAction(String text, int style) {
        super(text, style);
    }

    public MdaCutElementAction(String text) {
        super(text);
    }

    private List<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        IElement selectedElement = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                if (obj instanceof DependencyContainerAdapter || (selectedElement = (IElement)(adapter = (IAdaptable)obj).getAdapter(IElement.class)) instanceof IModule) continue;
                selectedElements.add(selectedElement);
            }
        }
        return selectedElements;
    }
}

