/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.workbench.PasteElementObject;
import com.modeliosoft.modelio.core.workbench.PasteElementTransfer;
import com.modeliosoft.modelio.core.workbench.TransferItem;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class MdaPasteElementAction
extends Action {
    public static final String ACTION_ID = "com.modeliosoft.modelio.mda.PasteElementCommandID";
    private MdaExplorerView mdaView = null;
    private Clipboard clipboard;

    public MdaPasteElementAction() {
        this.setActionDefinitionId(ACTION_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runWithEvent(Event event) {
        if (event.widget instanceof Tree || event.widget instanceof MenuItem) {
            ITransaction transaction;
            Object transactionManager;
            IModelingSession modelingSession;
            List selectedElements = this.getSelectedElements();
            if (selectedElements.size() != 1) return;
            IElement targetElement = (IElement)selectedElements.get(0);
            PasteElementObject pastedObject = (PasteElementObject)this.clipboard.getContents((Transfer)PasteElementTransfer.getInstance());
            if (pastedObject == null) {
                return;
            }
            List items = pastedObject.getTransferedItems();
            List pastedStereotypeItems = this.getStereotypesAsExtensions(items, targetElement);
            List pastedElements = this.getElementsToCopy(items, targetElement);
            boolean isLocalProfileSelected = targetElement instanceof IProfile && targetElement.getName().equals("LocalProfile");
            for (IElement element : pastedElements) {
                IAssociation targetAssociation;
                if (element instanceof IAssociation || element instanceof ILink) {
                    return;
                }
                if (element instanceof IParameter) {
                    IOperation targetOperation;
                    IParameter parameter = (IParameter)element;
                    if (!(targetElement instanceof IOperation) || parameter.getReturned() == null || (targetOperation = (IOperation)targetElement).getReturn() == null) continue;
                    return;
                }
                if (!(element instanceof IClassAssociation ? targetElement instanceof IAssociation && (targetAssociation = (IAssociation)targetElement).getLinkToClass() != null : isLocalProfileSelected && !(element instanceof IProfile))) continue;
                return;
            }
            if (pastedObject.getPasteType() == PasteElementObject.PasteType.COPY) {
                modelingSession = MdaExplorer.getInstance().getModelingSession();
                transactionManager = modelingSession.getTransactionManager();
                transaction = transactionManager.createTransaction("Copy");
                try {
                    try {
                        ArrayList copyResult = new ArrayList();
                        if (pastedElements.size() > 0) {
                            copyResult.addAll(ModelServices.copyTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement));
                        }
                        if (targetElement instanceof IModelElement) {
                            IModelElement selectedModelElement = (IModelElement)targetElement;
                            for (TransferItem item : pastedStereotypeItems) {
                                IStereotype stereotype = (IStereotype)item.getTransferedElement();
                                if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                                selectedModelElement.addExtension(stereotype);
                            }
                        }
                        transactionManager.commit(transaction);
                        transaction = null;
                        if (copyResult.size() < 1) return;
                        IElement copiedElement = (IElement)copyResult.get(0);
                        if (copiedElement instanceof INote) {
                            O.getDefault().getNavigateService().fireNavigate(copiedElement);
                            return;
                        } else {
                            this.mdaView.setExpandedState(targetElement, true);
                        }
                        return;
                    }
                    catch (InvalidTransactionException e) {
                        transaction = null;
                        if (transaction == null) return;
                        transactionManager.rollback(transaction);
                        return;
                    }
                    catch (Exception e) {
                        this.reportException(e);
                        if (transaction == null) return;
                        transactionManager.rollback(transaction);
                        return;
                    }
                }
                finally {
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            if (pastedObject.getPasteType() != PasteElementObject.PasteType.CUT) return;
            for (IElement element : pastedElements) {
                if (!element.equals((Object)targetElement) && !this.isParentOf(element, targetElement)) continue;
                return;
            }
            modelingSession = MdaExplorer.getInstance().getModelingSession();
            transactionManager = modelingSession.getTransactionManager();
            transaction = transactionManager.createTransaction("Cut");
            try {
                try {
                    if (pastedElements.size() > 0) {
                        ModelServices.moveTo((Collection)new ObList((Collection)pastedElements), (IElement)targetElement);
                    }
                    if (targetElement instanceof IModelElement) {
                        IModelElement selectedModelElement = (IModelElement)targetElement;
                        for (TransferItem item : pastedStereotypeItems) {
                            IStereotype stereotype = (IStereotype)item.getTransferedElement();
                            IModelElement oldParent = (IModelElement)item.getOldParent();
                            oldParent.removeExtension(stereotype);
                            if (selectedModelElement.isStereotyped(stereotype.getName())) continue;
                            selectedModelElement.addExtension(stereotype);
                        }
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                    if (pastedElements.size() >= 1) {
                        IElement movedElement = (IElement)pastedElements.get(0);
                        if (movedElement instanceof INote) {
                            O.getDefault().getNavigateService().fireNavigate(movedElement);
                        } else {
                            this.mdaView.setExpandedState(targetElement, true);
                        }
                    }
                    pastedObject.setPasteType(PasteElementObject.PasteType.COPY);
                    this.clipboard.setContents(new Object[]{pastedObject}, new Transfer[]{PasteElementTransfer.getInstance()});
                    return;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction == null) return;
                    transactionManager.rollback(transaction);
                    return;
                }
                catch (Exception e) {
                    this.reportException(e);
                    if (transaction == null) return;
                    transactionManager.rollback(transaction);
                    return;
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        if (!(event.widget instanceof Text)) return;
        Text text = (Text)event.widget;
        text.paste();
    }

    public MdaPasteElementAction(String text, ImageDescriptor image, Clipboard clipboard, MdaExplorerView view) {
        super(text, image);
        this.clipboard = clipboard;
        this.mdaView = view;
    }

    public MdaPasteElementAction(String text, int style) {
        super(text, style);
    }

    public MdaPasteElementAction(String text) {
        super(text);
    }

    private List<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private List<TransferItem> getStereotypesAsExtensions(List<TransferItem> items, IElement selectedElement) {
        ArrayList<TransferItem> stereotypeItemsToCopy = new ArrayList<TransferItem>();
        for (TransferItem item : items) {
            if (!(item.getTransferedElement() instanceof IStereotype) || selectedElement instanceof IProfile) continue;
            stereotypeItemsToCopy.add(item);
        }
        return stereotypeItemsToCopy;
    }

    private List<IElement> getElementsToCopy(List<TransferItem> items, IElement selectedElement) {
        ArrayList<IElement> elementsToCopy = new ArrayList<IElement>();
        for (TransferItem item : items) {
            IElement transferedElement = item.getTransferedElement();
            if (selectedElement instanceof IProfile) {
                elementsToCopy.add(transferedElement);
                continue;
            }
            if (transferedElement instanceof IStereotype) continue;
            elementsToCopy.add(transferedElement);
        }
        return elementsToCopy;
    }

    void reportException(Exception e) {
        String title = MdaExplorer.I18N.getMessage("CannotPasteClipboard", new String[0]);
        MessageDialog.openError(null, (String)title, (String)e.getLocalizedMessage());
        if (!(e instanceof InvalidModelManipulationException)) {
            LOG.error((String)"org.modelio.mda.explorer", (Throwable)e);
        }
    }
}

