/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.dnd;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class MdaExplorerDropAssistant
extends CommonDropAdapterAssistant {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        Object data = event.data;
        if (data == null || target == null) {
            return Status.CANCEL_STATUS;
        }
        IElement targetElement = null;
        if (target instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)target;
            targetElement = adapter.getElement();
        }
        List pastedElements = new ArrayList();
        List selectedStereotypes = new ArrayList();
        TransferData currentTransfer = dropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            selectedStereotypes = this.getStereotypesAsExtensions(this.getSelectedElements(), targetElement);
            pastedElements = this.getElementsToCopy(this.getSelectedElements(), targetElement);
        }
        if (pastedElements == null || targetElement == null) {
            return null;
        }
        if (event.detail == 1) {
            IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Copy");
            try {
                List copyResult = null;
                try {
                    if (pastedElements.size() > 0) {
                        copyResult = ModelServices.copyTo((Collection)new ObList(pastedElements), (IElement)targetElement);
                    }
                    if (targetElement instanceof IModelElement) {
                        IModelElement targetModelElement = (IModelElement)targetElement;
                        for (IStereotype selectedStereotype : selectedStereotypes) {
                            if (targetModelElement.isStereotyped(selectedStereotype.getName())) continue;
                            targetModelElement.addExtension(selectedStereotype);
                        }
                    }
                }
                catch (Exception e) {
                    transactionManager.rollback(transaction);
                    transaction = null;
                    MessageDialog.openError(null, (String)MdaExplorer.I18N.getMessage("CopyFailed", new String[0]), (String)e.getLocalizedMessage());
                    if (!(e instanceof InvalidModelManipulationException)) {
                        LOG.error((String)"org.modelio.mda.explorer", (Throwable)e);
                    }
                    if (transaction == null) return null;
                    transactionManager.rollback(transaction);
                    return null;
                }
                try {
                    transactionManager.commit(transaction);
                    transaction = null;
                    if (copyResult == null || copyResult.size() < 1) return null;
                    IElement copiedElement = (IElement)copyResult.get(0);
                    if (copiedElement instanceof INote) {
                        O.getDefault().getNavigateService().fireNavigate(copiedElement);
                        return null;
                    }
                    MdaExplorerView view = this.getMdaExplorerView();
                    if (view == null) return null;
                    view.setExpandedState(targetElement, true);
                    return null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                }
                return null;
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        if (event.detail != 2) return null;
        int i = 0;
        while (i < pastedElements.size()) {
            if (((IElement)pastedElements.get(i)).equals((Object)targetElement) || this.isParentOf((IElement)pastedElements.get(i), targetElement)) {
                return null;
            }
            ++i;
        }
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Cut");
        try {
            try {
                if (pastedElements.size() > 0) {
                    ModelServices.moveTo((Collection)new ObList(pastedElements), (IElement)targetElement);
                }
            }
            catch (Exception e) {
                transactionManager.rollback(transaction);
                transaction = null;
                MessageDialog.openError(null, (String)MdaExplorer.I18N.getMessage("MovingFailed", new String[0]), (String)e.getLocalizedMessage());
                if (!(e instanceof InvalidModelManipulationException)) {
                    e.printStackTrace();
                }
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
            try {
                transactionManager.commit(transaction);
                transaction = null;
                if (pastedElements.size() < 1) return null;
                IElement movedElement = (IElement)pastedElements.get(0);
                if (movedElement instanceof INote) {
                    O.getDefault().getNavigateService().fireNavigate(movedElement);
                    return null;
                }
                MdaExplorerView view = this.getMdaExplorerView();
                if (view == null) return null;
                view.setExpandedState(targetElement, true);
                return null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
            }
            return null;
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        List selectedElements = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            selectedElements = this.getSelectedElements();
        }
        IElement targetElement = null;
        if (target instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)target;
            targetElement = adapter.getElement();
        }
        if (selectedElements == null || targetElement == null || selectedElements.size() == 0) {
            return Status.CANCEL_STATUS;
        }
        if (targetElement instanceof IProfile && targetElement.getName().equals("LocalProfile")) {
            for (IElement element : selectedElements) {
                if (element instanceof IProfile) continue;
                return Status.CANCEL_STATUS;
            }
        }
        if (operation == 2) {
            int i = 0;
            while (i < selectedElements.size()) {
                if (((IElement)selectedElements.get(i)).equals((Object)targetElement) || this.isParentOf((IElement)selectedElements.get(i), targetElement)) {
                    return Status.CANCEL_STATUS;
                }
                ++i;
            }
        }
        for (IElement element : selectedElements) {
            IAssociation targetAssociation;
            String dep = CompositionExpert.getDefaultCompositionDep((IElement)targetElement, (IElement)element);
            if ((dep == null || dep.equals("")) && !(targetElement instanceof IProfile) && element instanceof IStereotype) {
                dep = "Extension";
            }
            if (dep == null || dep.equals("")) {
                return Status.CANCEL_STATUS;
            }
            if (element instanceof IAssociation || element instanceof ILink) {
                return Status.CANCEL_STATUS;
            }
            if (element instanceof IParameter) {
                IOperation targetOperation;
                IParameter parameter = (IParameter)element;
                if (targetElement instanceof IOperation && parameter.getReturned() != null && (targetOperation = (IOperation)targetElement).getReturn() != null) {
                    return Status.CANCEL_STATUS;
                }
            } else if (element instanceof IClassAssociation ? targetElement instanceof IAssociation && (targetAssociation = (IAssociation)targetElement).getLinkToClass() != null : element instanceof IModule) {
                return Status.CANCEL_STATUS;
            }
            if (operation != 2) continue;
            IElementStatus status = element.getElementStatus();
            if (!status.isModifiable()) {
                return Status.CANCEL_STATUS;
            }
            IElement parentElement = element.getCompositionOwner();
            status = parentElement.getElementStatus();
            if (status.isModifiable()) continue;
            return Status.CANCEL_STATUS;
        }
        IElementStatus status = targetElement.getElementStatus();
        if (!status.isModifiable()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                IAdaptable adapter;
                IElement element;
                if (!(o instanceof IAdaptable) || (element = (IElement)(adapter = (IAdaptable)o).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    private List<IStereotype> getStereotypesAsExtensions(List<IElement> elements, IElement target) {
        ArrayList<IStereotype> stereotypesList = new ArrayList<IStereotype>();
        for (IElement element : elements) {
            if (!(element instanceof IStereotype) || target instanceof IProfile) continue;
            stereotypesList.add((IStereotype)element);
        }
        return stereotypesList;
    }

    private List<IElement> getElementsToCopy(List<IElement> elements, IElement target) {
        ArrayList<IElement> elementsToCopy = new ArrayList<IElement>();
        for (IElement element : elements) {
            if (target instanceof IProfile) {
                elementsToCopy.add(element);
                continue;
            }
            if (element instanceof IStereotype) continue;
            elementsToCopy.add(element);
        }
        return elementsToCopy;
    }

    protected MdaExplorerView getMdaExplorerView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof MdaExplorerView) {
            return (MdaExplorerView)activePart;
        }
        return null;
    }
}

