/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.handlers;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.module.IPeerMdac;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class CreateModuleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        if (modelingSession == null) {
            return null;
        }
        IMdacRegistry mdacRegistry = modelingSession.getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        IMdac mdaDesignerModule = null;
        for (IMdac module : activeMdacs) {
            String moduleName = module.getName();
            if (moduleName == null || !moduleName.equals("MDADesigner") && !moduleName.equals("MDADesignerLight")) continue;
            IPeerMdac peer = module.getPeerMdac();
            try {
                Method createModuleMethod = peer.getClass().getMethod("createModule", new Class[0]);
                createModuleMethod.invoke((Object)peer, new Object[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (mdaDesignerModule != null && mdaDesignerModule instanceof IMdac) {
            IMdac mdaDesignerJavaModule = mdaDesignerModule;
            Collection moduleActions = mdaDesignerJavaModule.getMdacActions(ActionLocation.contextualpopup);
            for (IMdacAction moduleAction : moduleActions) {
                String actionName = moduleAction.getName();
                if (actionName == null || !actionName.equals("ModuleCreator")) continue;
                IElement[] selectedElements = new IElement[]{modelingSession.getModel().getProject()};
                moduleAction.getCommand().actionPerformed(new ObList(selectedElements), mdaDesignerJavaModule);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        if (modelingSession == null) {
            return false;
        }
        IMdacRegistry mdacRegistry = modelingSession.getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        Object mdaDesignerModule = null;
        for (IMdac module : activeMdacs) {
            String moduleName = module.getName();
            if (moduleName == null || !moduleName.equals("MDADesigner") && !moduleName.equals("MDADesignerLight")) continue;
            IPeerMdac peer = module.getPeerMdac();
            try {
                Method createModuleMethod = peer.getClass().getMethod("createModule", new Class[0]);
                return createModuleMethod != null;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return false;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (mdaDesignerModule != null && mdaDesignerModule instanceof IMdac) {
            Object mdaDesignerJavaModule = mdaDesignerModule;
            Collection moduleActions = mdaDesignerJavaModule.getMdacActions(ActionLocation.contextualpopup);
            for (IMdacAction moduleAction : moduleActions) {
                String actionName = moduleAction.getName();
                if (actionName == null || !actionName.equals("ModuleCreator")) continue;
                IElement[] selectedElements = new IElement[]{modelingSession.getModel().getProject()};
                return moduleAction.isActiveFor(selectedElements, false);
            }
        }
        return false;
    }

    public boolean isHandled() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        if (modelingSession == null) {
            return false;
        }
        IMdacRegistry mdacRegistry = modelingSession.getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        Object mdaDesignerModule = null;
        for (IMdac module : activeMdacs) {
            String moduleName = module.getName();
            if (moduleName == null || !moduleName.equals("MDADesigner") && !moduleName.equals("MDADesignerLight")) continue;
            IPeerMdac peer = module.getPeerMdac();
            try {
                Method createModuleMethod = peer.getClass().getMethod("createModule", new Class[0]);
                return createModuleMethod != null;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return false;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (mdaDesignerModule != null && mdaDesignerModule instanceof IMdac) {
            Object mdaDesignerJavaModule = mdaDesignerModule;
            Collection moduleActions = mdaDesignerJavaModule.getMdacActions(ActionLocation.contextualpopup);
            for (IMdacAction moduleAction : moduleActions) {
                String actionName = moduleAction.getName();
                if (actionName == null || !actionName.equals("ModuleCreator")) continue;
                IElement[] selectedElements = new IElement[]{modelingSession.getModel().getProject()};
                return moduleAction.accept(selectedElements);
            }
        }
        return false;
    }
}

