/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.handlers;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.ILink;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.mda.explorer.commands.MdaContextMenuModel;
import com.modeliosoft.modelio.mda.explorer.commands.MdaCreateSiblingElementServices;
import com.modeliosoft.modelio.mda.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerActionsManager;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateSiblingElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedElements = this.getSelectedElements();
        IElement parentElement = this.getCommonParent(selectedElements);
        MdaExplorerView view = this.getMdaExplorerView();
        MdaExplorerActionsManager actionManager = null;
        MdaContextMenuModel menuModel = null;
        if (view != null && (actionManager = view.getActionsManager()) != null) {
            menuModel = actionManager.getContextMenuModel();
        }
        if (parentElement != null) {
            for (IElement selectedElement : selectedElements) {
                MdaCreateSiblingElementServices visitor = new MdaCreateSiblingElementServices(menuModel);
                visitor.createSibling(parentElement, selectedElement);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        List selectedAdapters = this.getSelectedAdapters();
        for (IAdaptable adapter : selectedAdapters) {
            if (!(adapter instanceof DependencyContainerAdapter)) continue;
            return false;
        }
        List selectedElements = this.getSelectedElements();
        IElement parentElement = this.getCommonParent(selectedElements);
        if (parentElement == null) {
            return false;
        }
        boolean selectedElementAreCmsNodes = true;
        boolean selectedElementContainsRamcObject = false;
        for (IElement selectedElement : selectedElements) {
            IParameter selectedParameter;
            IElementStatus selectedElementStatus = selectedElement.getElementStatus();
            if (!selectedElementStatus.isCmsNode()) {
                selectedElementAreCmsNodes = false;
            }
            if (selectedElementStatus.isRamcObject()) {
                selectedElementContainsRamcObject = true;
            }
            if (selectedElement instanceof IAssociation || selectedElement instanceof ILink) {
                return false;
            }
            if (selectedElement instanceof IClassAssociation) {
                return false;
            }
            if (!(selectedElement instanceof IParameter ? (selectedParameter = (IParameter)selectedElement).getReturned() != null : selectedElement instanceof IModule)) continue;
            return false;
        }
        IElementStatus parentStatus = parentElement.getElementStatus();
        return (parentStatus.isModifiable() || selectedElementAreCmsNodes) && !parentStatus.isRamcObject() && !selectedElementContainsRamcObject;
    }

    public boolean isHandled() {
        return true;
    }

    private IElement getCommonParent(List<IElement> selectedElements) {
        IElement parentElement = null;
        IElement currentParentElement = null;
        for (IElement element : selectedElements) {
            currentParentElement = element.getCompositionOwner();
            if (currentParentElement == null) {
                return null;
            }
            if (parentElement == null) {
                parentElement = currentParentElement;
                continue;
            }
            if (parentElement.equals((Object)currentParentElement)) continue;
            return null;
        }
        return parentElement;
    }

    private List<IAdaptable> getSelectedAdapters() {
        ArrayList<IAdaptable> selectedElements = new ArrayList<IAdaptable>();
        MdaExplorerView view = this.getMdaExplorerView();
        if (view == null) {
            return selectedElements;
        }
        ISelection selection = view.getCommonViewer().getSelection();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add(adapter);
            }
        }
        return selectedElements;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        MdaExplorerView view = this.getMdaExplorerView();
        if (view == null) {
            return selectedElements;
        }
        ISelection selection = view.getCommonViewer().getSelection();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private MdaExplorerView getMdaExplorerView() {
        IViewReference[] viewRefs;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewRef.getId().equals("com.modeliosoft.modelio.mda.MdaExplorerContentID")) {
                return (MdaExplorerView)viewRef.getView(false);
            }
            ++n2;
        }
        return null;
    }
}

