/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SelectRootHandler
extends AbstractHandler
implements IModelChangeListener,
ISessionListener,
IElementUpdater {
    private IModelingSession modelingSession;

    public SelectRootHandler() {
        SelectRootHandler thisInstance = this;
        Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MdaExplorerView view = this.getMdaExplorerView();
        if (view != null) {
            IElement rootElement = view.getRootInput();
            if (rootElement != null && rootElement.equals((Object)view.getInput())) {
                this.selectRoot();
            } else {
                this.resetRoot();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        MdaExplorerView view = this.getMdaExplorerView();
        if (view != null) {
            if (view.getRootInput() != null && !view.getRootInput().equals((Object)view.getInput())) {
                return true;
            }
            List selectedElements = this.getSelectedElements();
            if (selectedElements.size() == 1) {
                IElement selectedElement = (IElement)selectedElements.get(0);
                return selectedElement.getCompositionOwner() != null;
            }
            return false;
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        MdaExplorerView view = this.getMdaExplorerView();
        IElementDeletedEvent[] deletedEvents = event.getDeleteEvents();
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void sessionClosed(IModelingSession modelingSession) {
        modelingSession.getModel().removeModelListener((IModelChangeListener)this);
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        modelingSession.getModel().addModelListener((IModelChangeListener)this);
    }

    public void updateElement(UIElement element, Map parameters) {
        IElement input;
        MdaExplorerView view = this.getMdaExplorerView();
        if (view != null && (input = view.getInput()) instanceof IPackage && input.getCompositionOwner() == null) {
            element.setChecked(false);
        }
    }

    private List<IElement> getSelectedElements() {
        MdaExplorerView view = this.getMdaExplorerView();
        ISelection selection = view.getCommonViewer().getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private MdaExplorerView getMdaExplorerView() {
        IViewReference[] viewRefs;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewRefs = page.getViewReferences();
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewRef = iViewReferenceArray[n2];
            if (viewRef.getId().equals("com.modeliosoft.modelio.mda.MdaExplorerContentID")) {
                return (MdaExplorerView)viewRef.getView(false);
            }
            ++n2;
        }
        return null;
    }

    private boolean needViewRootReset(MdaExplorerView view, IElementDeletedEvent[] deletedEvents) {
        Object input = view.getCommonViewer().getInput();
        if (input instanceof ModelElementAdapter) {
            ModelElementAdapter inputAdapter = (ModelElementAdapter)input;
            IElement intputElement = inputAdapter.getElement();
            IElement parentElement = null;
            IElementDeletedEvent[] iElementDeletedEventArray = deletedEvents;
            int n = deletedEvents.length;
            int n2 = 0;
            while (n2 < n) {
                IElementDeletedEvent event = iElementDeletedEventArray[n2];
                parentElement = event.getOldParent();
                if (parentElement.equals((Object)intputElement)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void resetRoot() {
        MdaExplorerView view = this.getMdaExplorerView();
        List selectedElements = this.getSelectedElements();
        if (view != null && this.modelingSession != null) {
            view.setInput(view.getRootInput());
            view.selectElements(selectedElements);
        }
    }

    private void selectRoot() {
        MdaExplorerView view;
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1 && (view = this.getMdaExplorerView()) != null) {
            IElement selectedElement = (IElement)selectedElements.get(0);
            view.setInput(selectedElement);
            view.selectElement(selectedElement);
        }
    }

    static /* synthetic */ boolean access$0(SelectRootHandler selectRootHandler, MdaExplorerView mdaExplorerView, IElementDeletedEvent[] iElementDeletedEventArray) {
        return selectRootHandler.needViewRootReset(mdaExplorerView, iElementDeletedEventArray);
    }

    static /* synthetic */ void access$1(SelectRootHandler selectRootHandler) {
        selectRootHandler.resetRoot();
    }
}

