/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.model;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.mda.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerAdapter;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerCardVisitor;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerContentVisitor;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.mda.explorer.model.RootElementAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class MdaExplorerContentProvider
implements ITreeContentProvider {
    private ModelElementAdapterCache adaptersCache;
    private MdaExplorerCardVisitor cardVisitor;
    private MdaExplorerContentVisitor modelVisitor = new MdaExplorerContentVisitor();

    public MdaExplorerContentProvider() {
        this.cardVisitor = new MdaExplorerCardVisitor();
        this.adaptersCache = new ModelElementAdapterCache();
    }

    public void dispose() {
    }

    public ModelElementAdapterCache getAdaptersCache() {
        return this.adaptersCache;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ModelElementAdapter) {
            ModelElementAdapter parentAdapter = (ModelElementAdapter)parent;
            return this.getModelElementChildren(parentAdapter);
        }
        if (parent instanceof DependencyContainerAdapter) {
            DependencyContainerAdapter parentAdapter = (DependencyContainerAdapter)parent;
            return this.getDependencyContainerChildren(parentAdapter);
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof RootElementAdapter) {
            ModelElementAdapter tmpRoot;
            RootElementAdapter rootAdapter = (RootElementAdapter)inputElement;
            ArrayList<MdaExplorerAdapter> children = rootAdapter.getChildrenAdapters();
            if (children.size() == 1 && (tmpRoot = (ModelElementAdapter)children.get(0)).getElement() instanceof IProject) {
                Object[] projectChildren = this.getModelElementChildren(tmpRoot);
                children = new ArrayList<MdaExplorerAdapter>();
                Object[] objectArray = projectChildren;
                int n = projectChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object projectChild = objectArray[n2];
                    if (projectChild instanceof MdaExplorerAdapter) {
                        children.add((MdaExplorerAdapter)projectChild);
                    }
                    ++n2;
                }
            }
            for (MdaExplorerAdapter child : children) {
                ModelElementAdapter childModelElement;
                IElement element;
                if (!(child instanceof ModelElementAdapter) || (element = (childModelElement = (ModelElementAdapter)child).getElement()) == null || this.adaptersCache.getAdapter(element) != null) continue;
                this.adaptersCache.addAdapter(element, childModelElement);
            }
            return children.toArray(new Object[children.size()]);
        }
        if (inputElement instanceof MdaExplorerAdapter) {
            MdaExplorerAdapter adapter = (MdaExplorerAdapter)inputElement;
            List children = adapter.getChildrenAdapters();
            for (MdaExplorerAdapter child : children) {
                ModelElementAdapter childModelElement;
                IElement element;
                if (!(child instanceof ModelElementAdapter) || (element = (childModelElement = (ModelElementAdapter)child).getElement()) == null || this.adaptersCache.getAdapter(element) != null) continue;
                this.adaptersCache.addAdapter(element, childModelElement);
            }
            return children.toArray(new Object[children.size()]);
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof MdaExplorerAdapter) {
            MdaExplorerAdapter childAdapter = (MdaExplorerAdapter)child;
            return childAdapter.getParentAdapter();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ModelElementAdapter) {
            int childrenNumber = 0;
            ModelElementAdapter parentAdapter = (ModelElementAdapter)parent;
            IElement parentElement = parentAdapter.getElement();
            if (parentElement != null) {
                childrenNumber = this.cardVisitor.getAllCard(parentElement);
            }
            return childrenNumber > 0;
        }
        return parent instanceof DependencyContainerAdapter;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.adaptersCache.clear();
    }

    private ModelElementAdapter getAdapter(List<MdaExplorerAdapter> childrenAdapters, IElement element) {
        for (MdaExplorerAdapter adapter : childrenAdapters) {
            ModelElementAdapter modelElementAdapter;
            if (!(adapter instanceof ModelElementAdapter) || !(modelElementAdapter = (ModelElementAdapter)adapter).getElement().equals((Object)element)) continue;
            return modelElementAdapter;
        }
        return null;
    }

    private Object[] getChildrenDependencyLinks(DependencyContainerAdapter parentAdapter, List<IElement> dependencyLinks) {
        int childrenNumber = dependencyLinks.size();
        Object[] children = new Object[childrenNumber];
        List childrenAdapters = parentAdapter.getChildrenAdapters();
        int i = 0;
        while (i < childrenNumber) {
            IElement element = dependencyLinks.get(i);
            ModelElementAdapter elementAdapter = this.getAdapter(childrenAdapters, element);
            if (elementAdapter == null) {
                elementAdapter = new ModelElementAdapter(element, (MdaExplorerAdapter)parentAdapter);
                childrenAdapters.add(elementAdapter);
                this.adaptersCache.addAdapter(element, elementAdapter);
            }
            children[i] = elementAdapter;
            ++i;
        }
        return children;
    }

    private Object[] getChildrenWithDependencyNode(ModelElementAdapter parentAdapter, List<IElement> directChildren) {
        int childrenNumber = directChildren.size() + 1;
        Object[] children = new Object[childrenNumber];
        List childrenAdapters = parentAdapter.getChildrenAdapters();
        int i = 0;
        while (i < childrenNumber - 1) {
            IElement element = directChildren.get(i);
            ModelElementAdapter elementAdapter = this.getAdapter(childrenAdapters, element);
            if (elementAdapter == null) {
                elementAdapter = new ModelElementAdapter(element, (MdaExplorerAdapter)parentAdapter);
                childrenAdapters.add(elementAdapter);
                this.adaptersCache.addAdapter(element, elementAdapter);
            }
            children[i] = elementAdapter;
            ++i;
        }
        DependencyContainerAdapter dependencyAdapter = parentAdapter.getDependencyAdapter();
        if (dependencyAdapter == null) {
            dependencyAdapter = new DependencyContainerAdapter((MdaExplorerAdapter)parentAdapter);
            parentAdapter.setDependencyAdapter(dependencyAdapter);
        }
        children[childrenNumber - 1] = dependencyAdapter;
        return children;
    }

    private Object[] getChildrenWithoutDependencyNode(ModelElementAdapter parentAdapter, List<IElement> directChildren) {
        int childrenNumber = directChildren.size();
        Object[] children = new Object[childrenNumber];
        List childrenAdapters = parentAdapter.getChildrenAdapters();
        int i = 0;
        while (i < childrenNumber) {
            IElement element = directChildren.get(i);
            ModelElementAdapter elementAdapter = this.getAdapter(childrenAdapters, element);
            if (elementAdapter == null) {
                elementAdapter = new ModelElementAdapter(element, (MdaExplorerAdapter)parentAdapter);
                childrenAdapters.add(elementAdapter);
                this.adaptersCache.addAdapter(element, elementAdapter);
            }
            children[i] = elementAdapter;
            ++i;
        }
        return children;
    }

    private Object[] getDependencyContainerChildren(DependencyContainerAdapter parentAdapter) {
        MdaExplorerAdapter realParentAdapter = parentAdapter.getParentAdapter();
        if (realParentAdapter instanceof ModelElementAdapter) {
            ModelElementAdapter elementAdapter = (ModelElementAdapter)realParentAdapter;
            IElement parentElement = elementAdapter.getElement();
            List auxiliaryChildren = this.modelVisitor.getAuxiliaryChildren(parentElement);
            return this.getChildrenDependencyLinks(parentAdapter, auxiliaryChildren);
        }
        return new Object[0];
    }

    private Object[] getModelElementChildren(ModelElementAdapter parentAdapter) {
        IElement parentElement = parentAdapter.getElement();
        if (parentElement != null) {
            List umlChildren = this.modelVisitor.getUmlChildren(parentElement);
            List auxiliaryChildren = this.modelVisitor.getAuxiliaryChildren(parentElement);
            Object[] children = null;
            children = auxiliaryChildren.size() > 0 ? this.getChildrenWithDependencyNode(parentAdapter, umlChildren) : this.getChildrenWithoutDependencyNode(parentAdapter, umlChildren);
            return children;
        }
        return new Object[0];
    }
}

