/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.popup.contrib;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.mda.explorer.popup.contrib.MdaElementCreationContributionItem;
import com.modeliosoft.modelio.ui.menu.contextual.CommandModel;
import com.modeliosoft.modelio.ui.menu.contextual.ContextMenuModel;
import com.modeliosoft.modelio.ui.menu.contextual.ItemModel;
import com.modeliosoft.modelio.ui.menu.contextual.MenuModel;
import com.modeliosoft.modelio.ui.menu.contextual.SeparatorModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;

public class MdaElementsCreationDynamicContribution
extends CompoundContributionItem {
    private static ContextMenuModel contextMenuModel;

    static {
        ResourceBundle propertiesBundle = ResourceBundle.getBundle("explorer-create-menus");
        Bundle bundle = Platform.getBundle((String)"org.modelio.mda.explorer");
        Path explorerContextualMenu = new Path("/res/explorer-create-popups.xml");
        URL url = FileLocator.find((Bundle)bundle, (IPath)explorerContextualMenu, null);
        contextMenuModel = new ContextMenuModel(url, propertiesBundle);
    }

    public MdaElementsCreationDynamicContribution() {
    }

    public MdaElementsCreationDynamicContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> list = new ArrayList<IContributionItem>();
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 0) {
            return list.toArray(new IContributionItem[list.size()]);
        }
        IElement selectedElement = (IElement)selectedElements.get(0);
        List itemModels = contextMenuModel.getItems(selectedElement.getMetaclassName(), null);
        if (selectedElement instanceof IModelElement) {
            for (IStereotype stereo : ((IModelElement)selectedElement).getExtension()) {
                List stereoItems = contextMenuModel.getItems(selectedElement.getMetaclassName(), stereo.getName());
                if (!itemModels.isEmpty() && !stereoItems.isEmpty()) {
                    itemModels.add(new SeparatorModel(stereo.getName()));
                }
                itemModels.addAll(stereoItems);
            }
        }
        IWorkbenchWindow serviceLocator = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        for (ItemModel itemModel : itemModels) {
            list.add(this.makeContributionItem(itemModel, commandService, handlerService));
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                IElement element;
                if (!(selectedObject instanceof IAdaptable) || (element = (IElement)((IAdaptable)selectedObject).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }

    private IContributionItem makeContributionItem(ItemModel itemModel, ICommandService commandService, IHandlerService handlerService) {
        if (itemModel instanceof CommandModel) {
            return MdaElementCreationContributionItem.create((CommandModel)((CommandModel)itemModel));
        }
        if (itemModel instanceof MenuModel) {
            MenuModel menuModel = (MenuModel)itemModel;
            MenuManager menuManager = new MenuManager(menuModel.getLabel(), menuModel.getImage(), menuModel.getId());
            for (ItemModel subItemModel : menuModel.getItems()) {
                menuManager.add(this.makeContributionItem(subItemModel, commandService, handlerService));
            }
            return menuManager;
        }
        if (itemModel instanceof SeparatorModel) {
            SeparatorModel separatorModel = (SeparatorModel)itemModel;
            String separatorId = separatorModel.getId();
            if (separatorId == null || separatorId.equals("")) {
                return new Separator();
            }
            return new Separator(separatorId);
        }
        return null;
    }
}

