/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCreateHandler
extends AbstractHandler {
    protected String dependency;
    protected String metaclass;
    protected String stereotype;

    protected abstract IElement create(IElement var1, IModelingSession var2) throws ExecutionException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.metaclass = event.getParameter("metaclass");
        this.dependency = event.getParameter("dependency");
        this.stereotype = event.getParameter("stereotype");
        IModelingSession modellingSession = MdaExplorer.getInstance().getModelingSession();
        ITransactionManager transactionManager = modellingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Create a " + this.metaclass);
        try {
            try {
                IElement element = this.create(this.getSelectedElement(), modellingSession);
                transactionManager.commit(transaction);
                transaction = null;
                this.postCommit(element);
            }
            catch (InvalidTransactionException exception) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return null;
    }

    protected IElement getSelectedElement() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IAdaptable) {
            IAdaptable adapter = (IAdaptable)((IStructuredSelection)selection).getFirstElement();
            return (IElement)adapter.getAdapter(IElement.class);
        }
        return null;
    }

    protected abstract void postCommit(IElement var1);

    public boolean isEnabled() {
        boolean singleSelection = false;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            singleSelection = ((IStructuredSelection)selection).size() == 1;
        }
        IElement selectedElement = this.getSelectedElement();
        return super.isEnabled() && singleSelection && selectedElement != null && selectedElement.getElementStatus().isModifiable();
    }
}

