/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.popup.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.mda.explorer.popup.handlers.AbstractExplorerCreateHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;

public class CreateElementHandler
extends AbstractExplorerCreateHandler {
    public IElement create(IElement selectedElement, IModelingSession modellingSession) throws ExecutionException {
        IElement element = modellingSession.getModelFactory().createElement(this.metaclass, selectedElement, this.dependency);
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            if (this.stereotype != null) {
                try {
                    IStereotype obstereotype = modellingSession.getModel().getProject().getStereotype(element.getClass(), this.stereotype);
                    modelElement.addExtension(obstereotype);
                }
                catch (StereotypeNotFoundException e) {
                    throw new ExecutionException("Could not create element", (Throwable)e);
                }
            }
            DefaultNameFactory.setDefaultName((IModelElement)modelElement);
        }
        return element;
    }

    public void setEnabled(Object evaluationContext) {
        IElement selectedElement;
        String dependencyFromContext;
        super.setEnabled(evaluationContext);
        if (!(evaluationContext instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        String metaclassFromContext = (String)context.getVariable("metaclass");
        if ("ClassAssociation".equals(metaclassFromContext) && "LinkToClass".equals(dependencyFromContext = (String)context.getVariable("dependency")) && (selectedElement = this.getSelectedElement()) instanceof IAssociation) {
            IAssociation targetAssociation = (IAssociation)selectedElement;
            this.setBaseEnabled(targetAssociation.getLinkToClass() == null);
        }
    }
}

