/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.showMdaView;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.showMdaView.ShowMdaViewHandler;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class ShowMdaViewHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("com.modeliosoft.modelio.mda.ShowMdaViewCommandID");
        State state = command.getState("com.modeliosoft.modelio.mda.ShowMdaViewCommandToggleID");
        boolean isSelected = (Boolean)state.getValue();
        if (!isSelected) {
            this.openExplorerView();
            state.setValue((Object)true);
        } else {
            this.closeExplorerView();
            state.setValue((Object)false);
        }
        service.refreshElements(command.getId(), null);
        return null;
    }

    public boolean isEnabled() {
        return MdaExplorer.getInstance().getModelingSession() != null;
    }

    private void openExplorerView() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        MdaExplorerView view = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            view = (MdaExplorerView)page.showView("com.modeliosoft.modelio.mda.MdaExplorerContentID", null, 3);
            if (view != null) {
                IProject project = modelingSession.getModel().getProject();
                view.sessionOpened(modelingSession);
                view.setRootInput((IElement)project);
                Display.getCurrent().asyncExec((Runnable)new ActivateViewRunnable(this, page, view));
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void closeExplorerView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] viewsReferences = page.getViewReferences();
        int i = 0;
        while (i < viewsReferences.length) {
            if (viewsReferences[i].getId().equals("com.modeliosoft.modelio.mda.MdaExplorerContentID")) {
                MdaExplorerView view = (MdaExplorerView)viewsReferences[i].getView(false);
                if (view != null) {
                    view.sessionClosed(MdaExplorer.getInstance().getModelingSession());
                    view.setRootInput(null);
                }
                page.hideView(viewsReferences[i]);
            }
            ++i;
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("com.modeliosoft.modelio.mda.ShowMdaViewCommandID");
        State state = command.getState("com.modeliosoft.modelio.mda.ShowMdaViewCommandToggleID");
        boolean isSelected = (Boolean)state.getValue();
        element.setChecked(isSelected);
    }
}

