/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ExplorerMdacAction
extends Action {
    private String name;
    private IMdacContextualCommand command;
    private IMdac javaMdac;

    public ExplorerMdacAction(IMdac javaMdac, String name, String label, String tooltip, ImageDescriptor imageDescriptor, IMdacContextualCommand command) {
        this.javaMdac = javaMdac;
        this.name = name;
        this.setText(label);
        this.setToolTipText(tooltip);
        this.command = command;
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
    }

    public void run() {
        ObList selectedElements = new ObList((Collection)this.getSelectedElements());
        this.command.actionPerformed(selectedElements, this.javaMdac);
    }

    private ArrayList<IElement> getSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    public String getName() {
        return this.name;
    }

    public IMdacContextualCommand getCommand() {
        return this.command;
    }

    public IMdac getJavaMdac() {
        return this.javaMdac;
    }
}

