/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerActionsManager;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class MdaExplorerActionProvider
extends CommonActionProvider {
    private ICommonActionExtensionSite site;

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ArrayList selectedElements = this.getSelectedElements();
        this.fillCreationContextMenu(menu, selectedElements);
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.site = site;
    }

    private void fillCreationContextMenu(IMenuManager menu, ArrayList<IElement> selectedElements) {
        MdaExplorerView view = this.getUmlNavigatorView();
        if (view != null) {
            MdaExplorerActionsManager actionsManager = view.getActionsManager();
            actionsManager.fillContextMenu(menu, selectedElements);
        }
    }

    private ArrayList<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            IAdaptable adapter = null;
            if (selection instanceof IStructuredSelection) {
                List selectedObjects = ((IStructuredSelection)selection).toList();
                for (Object obj : selectedObjects) {
                    adapter = (IAdaptable)obj;
                    IElement selectedElement = (IElement)adapter.getAdapter(IElement.class);
                    if (selectedElement == null) continue;
                    selectedElements.add(selectedElement);
                }
            }
        }
        return selectedElements;
    }

    private ISelectionProvider getSelectionProvider() {
        ICommonViewerSite viewSite = this.site.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            return workbenchSite.getSelectionProvider();
        }
        return null;
    }

    private MdaExplorerView getUmlNavigatorView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] references = page.getViewReferences();
        int i = 0;
        while (i < references.length) {
            if (references[i].getId().equals("com.modeliosoft.modelio.mda.MdaExplorerContentID")) {
                return (MdaExplorerView)references[i].getView(true);
            }
            ++i;
        }
        return null;
    }
}

