/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.CmsNodeExpert;
import com.modeliosoft.modelio.explorer.commands.AuditElementAction;
import com.modeliosoft.modelio.explorer.popup.model.AbstractCreateAction;
import com.modeliosoft.modelio.mda.explorer.commands.CommandModel;
import com.modeliosoft.modelio.mda.explorer.commands.ItemModel;
import com.modeliosoft.modelio.mda.explorer.commands.MdaAddStereotypeAction;
import com.modeliosoft.modelio.mda.explorer.commands.MdaContextMenuModel;
import com.modeliosoft.modelio.mda.explorer.commands.MdaCopyElementAction;
import com.modeliosoft.modelio.mda.explorer.commands.MdaCutElementAction;
import com.modeliosoft.modelio.mda.explorer.commands.MdaDeleteElementAction;
import com.modeliosoft.modelio.mda.explorer.commands.MdaPasteElementAction;
import com.modeliosoft.modelio.mda.explorer.commands.MdaRenameElementAction;
import com.modeliosoft.modelio.mda.explorer.commands.MenuModel;
import com.modeliosoft.modelio.mda.explorer.commands.OpenRelatedDiagramAction;
import com.modeliosoft.modelio.mda.explorer.commands.SeparatorModel;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.ExplorerMdacAction;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerActionsManager;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MdaExplorerActionsManager {
    private AuditElementAction auditElementAction;
    private MdaContextMenuModel contextMenuModel;
    private MdaCopyElementAction copyElementAction;
    private MdaCutElementAction cutElementAction;
    private MdaDeleteElementAction deleteElementAction;
    private boolean enableActions = true;
    private MdaPasteElementAction pasteElementAction;
    private MdaRenameElementAction renameElementAction;
    private MdaExplorerView view;
    private MdaAddStereotypeAction mdaAddStereotypeAction;
    private Collection<String> cmsNodeTypes = null;
    private Clipboard clipboard;

    public MdaExplorerActionsManager(MdaExplorerView view) {
        this.view = view;
        this.contextMenuModel = new MdaContextMenuModel();
        this.clipboard = new Clipboard(Display.getCurrent());
        this.cmsNodeTypes = CmsNodeExpert.getCmsNodeMetaclasses();
        this.makeActions();
    }

    protected void finalize() throws Throwable {
        this.clipboard.dispose();
        super.finalize();
    }

    public void disableActions() {
        this.enableActions = false;
        this.auditElementAction.setEnabled(false);
        this.copyElementAction.setEnabled(false);
        this.cutElementAction.setEnabled(false);
        this.deleteElementAction.setEnabled(false);
        this.pasteElementAction.setEnabled(false);
        this.renameElementAction.setEnabled(false);
        this.mdaAddStereotypeAction.setEnabled(false);
    }

    public void enableActions() {
        this.enableActions = true;
        this.auditElementAction.setEnabled(true);
        this.copyElementAction.setEnabled(true);
        this.cutElementAction.setEnabled(true);
        this.deleteElementAction.setEnabled(true);
        this.pasteElementAction.setEnabled(true);
        this.renameElementAction.setEnabled(true);
        this.mdaAddStereotypeAction.setEnabled(true);
    }

    public void fillContextMenu(IMenuManager manager, List<IElement> selectedElements) {
        manager.removeAll();
        manager.updateAll(true);
        if (this.enableActions) {
            this.fillStaticMenu(manager, selectedElements);
            this.fillRelatedDiagramMenu(manager, selectedElements);
        }
    }

    public MdaExplorerView getView() {
        return this.view;
    }

    public void insertInSlot(Map<String, IMenuManager> slotMap, IMenuManager menu, List<String> slots, IAction action, IMdacAction mdacAction) {
        IMenuManager menuOwner = menu;
        IMenuManager subIMenuManager = menu;
        String slotCompleteName = "";
        for (String slotSimpleName : slots) {
            subIMenuManager = slotMap.get(slotCompleteName = String.valueOf(slotCompleteName) + (slotCompleteName.isEmpty() ? "" : "|") + slotSimpleName);
            if (subIMenuManager == null) {
                subIMenuManager = new MenuManager(slotSimpleName, mdacAction.getSlotImage(slots.indexOf(slotSimpleName)), null);
                slotMap.put(slotCompleteName, subIMenuManager);
            }
            menuOwner.add((IContributionItem)subIMenuManager);
            menuOwner = subIMenuManager;
        }
        subIMenuManager.add(action);
    }

    public void setModifyActionsEnabled(boolean enable) {
        this.cutElementAction.setEnabled(enable);
        this.pasteElementAction.setEnabled(enable);
        this.deleteElementAction.setEnabled(enable);
        this.mdaAddStereotypeAction.setEnabled(enable);
    }

    protected void fillCreationMenu(IMenuManager manager, List<IElement> selectedElements) {
        if (selectedElements.size() <= 0) {
            return;
        }
        String metaclass = selectedElements.get(0).getMetaclassName();
        manager.add((IContributionItem)new Separator("CreationMenus"));
        List items = this.contextMenuModel.getItems(metaclass);
        for (ItemModel item : items) {
            this.addActionItem(manager, selectedElements, item);
        }
    }

    protected void fillMDAMenu(IMenuManager manager, List<IElement> selectedElements) {
        if (selectedElements.size() <= 0) {
            return;
        }
        IMdacRegistry mdacRegistry = MdaExplorer.getInstance().getModelingSession().getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        manager.add((IContributionItem)new Separator("MDACMenus"));
        for (IMdac javaMdac : activeMdacs) {
            if (!this.hasCommandToDisplay(javaMdac, selectedElements)) continue;
            ImageDescriptor mdacBitmap = javaMdac.getMdacImageDescriptor();
            MenuManager subMenu = null;
            subMenu = mdacBitmap != null ? new MenuManager(javaMdac.getLabel(), mdacBitmap, javaMdac.getName()) : new MenuManager(javaMdac.getLabel(), javaMdac.getName());
            HashMap slotMap = new HashMap();
            Collection mdacActions = javaMdac.getMdacActions(ActionLocation.toolbar);
            for (IMdacAction mdacAction : mdacActions) {
                if (!mdacAction.accept(selectedElements.toArray(new IElement[selectedElements.size()]))) continue;
                IAction action = this.createAction(javaMdac, mdacAction, selectedElements);
                List slots = mdacAction.getSlots();
                if (slots != null && !slots.isEmpty()) {
                    this.insertInSlot(slotMap, (IMenuManager)subMenu, slots, action, mdacAction);
                    continue;
                }
                subMenu.add(action);
            }
            manager.add((IContributionItem)subMenu);
        }
    }

    protected void fillStaticMenu(IMenuManager manager, List<IElement> selectedElements) {
        manager.add((IContributionItem)new Separator("MdaMenu"));
        manager.add((IAction)this.mdaAddStereotypeAction);
        if (this.acceptsStaticMenu(selectedElements)) {
            manager.add((IContributionItem)new Separator("StaticMenu"));
            if (this.containsReadonlyElement(selectedElements)) {
                this.setModifyActionsEnabled(false);
            } else if (this.containsCopyDisabledElement(selectedElements)) {
                this.cutElementAction.setEnabled(false);
                this.pasteElementAction.setEnabled(false);
                this.copyElementAction.setEnabled(false);
            } else {
                this.setModifyActionsEnabled(true);
                this.copyElementAction.setEnabled(true);
            }
            manager.add((IAction)this.cutElementAction);
            manager.add((IAction)this.copyElementAction);
            manager.add((IAction)this.pasteElementAction);
            manager.add((IAction)this.deleteElementAction);
            manager.add((IContributionItem)new Separator("audit"));
            manager.add((IAction)this.auditElementAction);
        }
    }

    private boolean acceptsStaticMenu(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            AcceptStaticEntriesVisitor visitor = new AcceptStaticEntriesVisitor(this);
            visitor.accepted = true;
            element.accept((IMetamodelVisitor)visitor);
            if (visitor.accepted) continue;
            return false;
        }
        return true;
    }

    private void addActionItem(IMenuManager manager, List<IElement> selectedElements, ItemModel item) {
        if (item instanceof CommandModel) {
            AbstractCreateAction abstractCreateAction = ((CommandModel)item).getAction();
            if (abstractCreateAction.accept(selectedElements)) {
                if (this.containsRamcElement(selectedElements)) {
                    abstractCreateAction.setEnabled(false);
                } else if (this.containsReadonlyElement(selectedElements) && !this.cmsNodeTypes.contains(abstractCreateAction.getTargetClass())) {
                    abstractCreateAction.setEnabled(false);
                } else {
                    abstractCreateAction.setEnabled(abstractCreateAction.isActiveFor(selectedElements));
                }
                manager.add((IAction)abstractCreateAction);
            }
        } else if (item instanceof MenuModel) {
            MenuModel menuItem = (MenuModel)item;
            List items = menuItem.getItems();
            if (items.size() > 0) {
                MenuManager menu = new MenuManager(menuItem.getLabel(), menuItem.getImage(), menuItem.getId());
                for (ItemModel model : items) {
                    this.addActionItem((IMenuManager)menu, selectedElements, model);
                }
                manager.add((IContributionItem)menu);
            }
        } else if (item instanceof SeparatorModel) {
            SeparatorModel separatorItem = (SeparatorModel)item;
            String separatorId = separatorItem.getId();
            if (separatorId == null || separatorId.equals("")) {
                manager.add((IContributionItem)new Separator());
            } else {
                manager.add((IContributionItem)new Separator(separatorId));
            }
        }
    }

    private boolean containsRamcElement(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            IElementStatus elementStatus = element.getElementStatus();
            if (!elementStatus.isRamcObject()) continue;
            return true;
        }
        return false;
    }

    private boolean containsReadonlyElement(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            IElementStatus elementStatus = element.getElementStatus();
            if (elementStatus.isModifiable()) continue;
            return true;
        }
        return false;
    }

    private IAction createAction(IMdac javaMdac, IMdacAction mdacAction, List<IElement> selectedElements) {
        String name = mdacAction.getName();
        String label = mdacAction.getLabel();
        String tooltip = mdacAction.getTooltip();
        ImageDescriptor imageDescriptor = mdacAction.getBitmap();
        IMdacContextualCommand command = mdacAction.getCommand();
        ExplorerMdacAction action = new ExplorerMdacAction(javaMdac, name, label, tooltip, imageDescriptor, command);
        if (!mdacAction.isActiveFor(selectedElements.toArray(new IElement[selectedElements.size()]), false)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
        return action;
    }

    private void fillRelatedDiagramMenu(IMenuManager manager, List<IElement> selectedElements) {
        if (selectedElements.size() != 1) {
            return;
        }
        IElement currentElement = selectedElements.get(0);
        if (!(currentElement instanceof IModelElement)) {
            return;
        }
        IModelElement currentModelElement = (IModelElement)currentElement;
        ObList dependencies = currentModelElement.getDependsOnDependency();
        ArrayList<IAbstractDiagram> relatedDiagrams = new ArrayList<IAbstractDiagram>();
        for (IDependency dependency : dependencies) {
            IModelElement relatedElement;
            if (!dependency.isStereotyped("related_diagram") || !((relatedElement = dependency.getDependsOn()) instanceof IAbstractDiagram)) continue;
            relatedDiagrams.add((IAbstractDiagram)relatedElement);
        }
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.mda.explorer", (String)"icons/umldiagram.png");
        MenuManager subMenu = new MenuManager(MdaExplorer.I18N.getString("related_diagram"), image, "related_diagram");
        manager.add((IContributionItem)subMenu);
        if (relatedDiagrams.size() > 0) {
            for (IAbstractDiagram relatedDiagram : relatedDiagrams) {
                ImageDescriptor desc = ImageDescriptor.createFromImage((Image)StandardImageService.getStereotypedImage((IElement)relatedDiagram, null));
                OpenRelatedDiagramAction openAction = new OpenRelatedDiagramAction(relatedDiagram.getName(), desc, relatedDiagram);
                subMenu.add((IAction)openAction);
            }
        }
    }

    private boolean hasCommandToDisplay(IMdac javaMdac, List<IElement> selectedElements) {
        Collection mdacActions = javaMdac.getMdacActions(ActionLocation.contextualpopup);
        for (IMdacAction mdacAction : mdacActions) {
            if (!mdacAction.accept(selectedElements.toArray(new IElement[selectedElements.size()]))) continue;
            return true;
        }
        return false;
    }

    private void makeActions() {
        ImageDescriptor desc;
        ImageDescriptor addStereotypeDesc;
        IHandlerService handlerService = null;
        handlerService = (IHandlerService)this.view.getSite().getService(IHandlerService.class);
        ImageDescriptor cutElementDesc = StandardImageService.getImageDescriptor((String)"core.element.cut");
        this.cutElementAction = new MdaCutElementAction(MdaExplorer.I18N.getString("Cut"), cutElementDesc, this.clipboard);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.mda.CutElementCommandID", (IHandler)new ActionHandler((IAction)this.cutElementAction));
        }
        ImageDescriptor copyElementDesc = StandardImageService.getImageDescriptor((String)"core.element.copy");
        this.copyElementAction = new MdaCopyElementAction(MdaExplorer.I18N.getString("Copy"), copyElementDesc, this.clipboard);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.mda.CopyElementCommandID", (IHandler)new ActionHandler((IAction)this.copyElementAction));
        }
        ImageDescriptor pasteElementDesc = StandardImageService.getImageDescriptor((String)"core.element.paste");
        this.pasteElementAction = new MdaPasteElementAction(MdaExplorer.I18N.getString("Paste"), pasteElementDesc, this.clipboard, this.view);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.mda.PasteElementCommandID", (IHandler)new ActionHandler((IAction)this.pasteElementAction));
        }
        ImageDescriptor deleteElementDesc = StandardImageService.getImageDescriptor((String)"core.element.delete");
        this.deleteElementAction = new MdaDeleteElementAction(MdaExplorer.I18N.getString("Delete"), deleteElementDesc);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.mda.DeleteElementCommandID", (IHandler)new ActionHandler((IAction)this.deleteElementAction));
        }
        ImageDescriptor auditElementDesc = StandardImageService.getImageDescriptor((String)"core.check.model");
        this.auditElementAction = new AuditElementAction(MdaExplorer.I18N.getString("Audit"), auditElementDesc);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.AuditElementCommandID", (IHandler)new ActionHandler((IAction)this.auditElementAction));
        }
        this.renameElementAction = new MdaRenameElementAction(MdaExplorer.I18N.getString("Rename"));
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.mda.RenameElementCommandID", (IHandler)new ActionHandler((IAction)this.renameElementAction));
        }
        if ((addStereotypeDesc = StandardImageService.getImageDescriptor((String)"AddStereotype")) == null && (desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.mda.explorer", (String)"icons/addStereotype_16.png")) != null) {
            StandardImageService.declareImage((String)"AddStereotype", (ImageDescriptor)desc);
            addStereotypeDesc = StandardImageService.getImageDescriptor((String)"AddStereotype");
        }
        this.mdaAddStereotypeAction = new MdaAddStereotypeAction(this.view, MdaExplorer.I18N.getString("AddStereotype"), addStereotypeDesc);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.AddStereotypeCommandID", (IHandler)new ActionHandler((IAction)this.mdaAddStereotypeAction));
        }
    }

    public AuditElementAction getAuditElementAction() {
        return this.auditElementAction;
    }

    public MdaContextMenuModel getContextMenuModel() {
        return this.contextMenuModel;
    }

    public MdaCopyElementAction getCopyElementAction() {
        return this.copyElementAction;
    }

    public MdaCutElementAction getCutElementAction() {
        return this.cutElementAction;
    }

    public MdaDeleteElementAction getDeleteElementAction() {
        return this.deleteElementAction;
    }

    public MdaPasteElementAction getPasteElementAction() {
        return this.pasteElementAction;
    }

    public boolean isEnableActions() {
        return this.enableActions;
    }

    public MdaRenameElementAction getRenameElementAction() {
        return this.renameElementAction;
    }

    public MdaAddStereotypeAction getMdaAddStereotypeAction() {
        return this.mdaAddStereotypeAction;
    }

    private boolean containsCopyDisabledElement(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            if (!(element instanceof IModule)) continue;
            return true;
        }
        return false;
    }
}

