/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.mda.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerAdapter;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerContentVisitor;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerLabelService;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class MdaExplorerLabelProvider
extends LabelProvider
implements IColorProvider {
    MdaExplorerLabelService labelService = new MdaExplorerLabelService();

    private Image getImage(ModelElementAdapter mea) {
        IElement element = mea.getElement();
        return StandardImageService.getCmsStereotypedImage((IElement)element, null);
    }

    private String getText(ModelElementAdapter mea) {
        if (mea == null) {
            return "<null>";
        }
        IElement element = mea.getElement();
        if (element != null) {
            return this.labelService.getLabel(element);
        }
        return mea.toString();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        IElementStatus status;
        ModelElementAdapter adapter;
        IElement modelElement;
        Color color = null;
        if (element instanceof ModelElementAdapter && (modelElement = (adapter = (ModelElementAdapter)element).getElement()) != null && (status = modelElement.getElementStatus()).isRamcObject()) {
            color = Display.getCurrent().getSystemColor(15);
        }
        return color;
    }

    public Image getImage(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelElementAdapter) {
            return this.getImage((ModelElementAdapter)obj);
        }
        if (obj instanceof DependencyContainerAdapter) {
            return this.getImage((DependencyContainerAdapter)obj);
        }
        return null;
    }

    public MdaExplorerLabelService getLabelService() {
        return this.labelService;
    }

    public String getText(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        if (obj instanceof ModelElementAdapter) {
            return this.getText((ModelElementAdapter)obj);
        }
        if (obj instanceof DependencyContainerAdapter) {
            return this.getText((DependencyContainerAdapter)obj);
        }
        return obj.toString();
    }

    private Image getImage(DependencyContainerAdapter dca) {
        ImageDescriptor image = null;
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.mda.explorer");
        Path bitmapPath = new Path("icons/links_16.png");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        image = ImageDescriptor.createFromURL((URL)bitmapUrl);
        return image.createImage();
    }

    private String getText(DependencyContainerAdapter dca) {
        if (dca == null) {
            return "<null>";
        }
        MdaExplorerContentVisitor modelVisitor = new MdaExplorerContentVisitor();
        MdaExplorerAdapter parentAdapter = dca.getParentAdapter();
        int linksNumber = 0;
        if (parentAdapter instanceof ModelElementAdapter) {
            ModelElementAdapter modelParentAdapter = (ModelElementAdapter)parentAdapter;
            linksNumber = modelVisitor.getAuxiliaryChildren(modelParentAdapter.getElement()).size();
        }
        StringBuffer symbol = new StringBuffer();
        if (linksNumber <= 1) {
            symbol.append(linksNumber);
            symbol.append(" link");
        } else {
            symbol.append(linksNumber);
            symbol.append(" links");
        }
        return symbol.toString();
    }
}

