/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerCanBeSelectedVisitor;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.commands.ICommandService;

public class MdaExplorerNavigateListener
implements INavigationListener {
    private MdaExplorerView view;

    public MdaExplorerNavigateListener(MdaExplorerView view) {
        this.view = view;
    }

    public MdaExplorerView getView() {
        return this.view;
    }

    public void navigateTo(IElement target) {
        this.view.selectElement(target);
        List selectedElements = this.getSelectedElements();
        MdaExplorerCanBeSelectedVisitor visitor = new MdaExplorerCanBeSelectedVisitor();
        if (!selectedElements.contains(target) && visitor.canBeSelected(target)) {
            this.view.setInput(this.view.getRootInput());
            ViewerFilter[] filter = new ViewerFilter[]{};
            this.view.getCommonViewer().setFilters(filter);
            if (this.view != null) {
                ICommandService commandService = (ICommandService)this.view.getSite().getService(ICommandService.class);
                commandService.refreshElements("com.modeliosoft.modelio.mda.SelectRootHandlerID", null);
            }
            this.view.selectElement(target);
        }
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        IAdaptable adapter = null;
        ISelection selection = this.view.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                if (!(obj instanceof IAdaptable)) continue;
                adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }
}

