/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.util.ISharedImages;
import com.modeliosoft.modelio.mda.explorer.util.MdaExplorerUI;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MdaExplorerPickingManager
implements IPickingProvider,
MouseListener,
MouseTrackListener,
MouseMoveListener {
    private IElement rootPickingElement = null;
    private MdaExplorerView view;
    private Cursor cursor;
    private Cursor defaultCursor;
    private Cursor noCursor;
    private Cursor yesCursor;

    public MdaExplorerPickingManager(MdaExplorerView view) {
        ImageDescriptor pickingYesDesc;
        ImageDescriptor pickingNoDesc;
        this.view = view;
        ISharedImages sharedImages = MdaExplorerUI.getSharedImages();
        ImageDescriptor pickingDesc = sharedImages.getImageDescriptor("picking.cursor");
        if (pickingDesc == null) {
            sharedImages.declareImage("picking.cursor", "icons/picking_cursor.png");
            pickingDesc = sharedImages.getImageDescriptor("picking.cursor");
        }
        if (this.cursor == null) {
            this.cursor = new Cursor((Device)Display.getCurrent(), pickingDesc.getImageData(), 10, 9);
        }
        if ((pickingNoDesc = sharedImages.getImageDescriptor("picking.cursor.no")) == null) {
            sharedImages.declareImage("picking.cursor.no", "icons/picking_cursor_no.png");
            pickingNoDesc = sharedImages.getImageDescriptor("picking.cursor.no");
        }
        if (this.noCursor == null) {
            this.noCursor = new Cursor((Device)Display.getCurrent(), pickingNoDesc.getImageData(), 10, 9);
        }
        if ((pickingYesDesc = sharedImages.getImageDescriptor("picking.cursor.yes")) == null) {
            sharedImages.declareImage("picking.cursor.yes", "icons/picking_cursor_yes.png");
            pickingYesDesc = sharedImages.getImageDescriptor("picking.cursor.yes");
        }
        if (this.yesCursor == null) {
            this.yesCursor = new Cursor((Device)Display.getCurrent(), pickingYesDesc.getImageData(), 10, 9);
        }
        this.defaultCursor = view.getCommonViewer().getTree().getCursor();
    }

    public void beginPicking() {
        List selection = this.getRootSelection();
        if (selection.size() == 1) {
            this.rootPickingElement = (IElement)selection.get(0);
        }
        this.view.getCommonViewer().getTree().addMouseListener((MouseListener)this);
        this.view.getCommonViewer().getTree().addMouseTrackListener((MouseTrackListener)this);
        this.view.getCommonViewer().getTree().addMouseMoveListener((MouseMoveListener)this);
        this.view.getActionsManager().disableActions();
    }

    public void dispose() {
        if (this.cursor != null) {
            this.cursor.dispose();
        }
        if (this.noCursor != null) {
            this.noCursor.dispose();
        }
        if (this.yesCursor != null) {
            this.yesCursor.dispose();
        }
    }

    public void endPicking() {
        this.view.getCommonViewer().getTree().removeMouseListener((MouseListener)this);
        this.view.getCommonViewer().getTree().removeMouseTrackListener((MouseTrackListener)this);
        this.view.getCommonViewer().getTree().removeMouseMoveListener((MouseMoveListener)this);
        this.view.getCommonViewer().getTree().setCursor(this.defaultCursor);
        this.view.getActionsManager().enableActions();
        if (this.rootPickingElement != null) {
            this.view.selectElement(this.rootPickingElement);
        }
    }

    public MdaExplorerView getView() {
        return this.view;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
        this.view.getCommonViewer().getTree().setCursor(this.cursor);
    }

    public void mouseExit(MouseEvent e) {
        this.view.getCommonViewer().getTree().setCursor(this.defaultCursor);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        Object data;
        Tree tree;
        TreeItem item;
        IElement element = null;
        Object source = e.getSource();
        if (source instanceof Tree && (item = (tree = (Tree)source).getItem(new Point(e.x, e.y))) != null && (data = item.getData()) instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)data;
            element = adapter.getElement();
        }
        if (element != null) {
            if (O.getDefault().getPickingProviderService().acceptElement(element)) {
                this.view.getCommonViewer().getTree().setCursor(this.yesCursor);
            } else {
                this.view.getCommonViewer().getTree().setCursor(this.noCursor);
            }
        } else {
            this.view.getCommonViewer().getTree().setCursor(this.cursor);
        }
    }

    public void mouseUp(MouseEvent e) {
        IElement selectedElement;
        if (e.button == 1 && (selectedElement = this.getPickedElement(e)) != null && O.getDefault().getPickingProviderService().acceptElement(selectedElement)) {
            O.getDefault().getPickingProviderService().setElement(selectedElement);
        }
    }

    private IElement getPickedElement(MouseEvent e) {
        Object data;
        Tree tree;
        TreeItem item;
        Object source = e.getSource();
        if (source instanceof Tree && (item = (tree = (Tree)source).getItem(new Point(e.x, e.y))) != null && (data = item.getData()) instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)data;
            return adapter.getElement();
        }
        return null;
    }

    private List<IElement> getRootSelection() {
        ArrayList<IElement> selectionList = new ArrayList<IElement>();
        ISelection selection = this.view.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                if (!(object instanceof IAdaptable)) continue;
                IAdaptable adapter = (IAdaptable)object;
                IElement element = (IElement)adapter.getAdapter(IElement.class);
                selectionList.add(element);
            }
        }
        return selectionList;
    }
}

