/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IUsage;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageImport;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageMerge;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.INavigationService;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.IPickingProviderService;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.mda.explorer.model.DependencyContainerAdapter;
import com.modeliosoft.modelio.mda.explorer.model.MdaExplorerContentProvider;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapterCache;
import com.modeliosoft.modelio.mda.explorer.model.RootElementAdapter;
import com.modeliosoft.modelio.mda.explorer.views.ElementNameModifier;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerActionsManager;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerActivateSender;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerEditorActivationStrategy;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerLabelProvider;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerModelChangeListener;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerNavigateListener;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerPickingManager;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerViewUpdater;
import com.modeliosoft.modelio.mda.explorer.views.MdaStyledLabelProviderAdapter;
import com.modeliosoft.modelio.mda.explorer.views.MdaTreeViewerListener;
import com.modeliosoft.modelio.mda.explorer.views.history.SelectionHistory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class MdaExplorerView
extends CommonNavigator
implements ISessionListener {
    public static final String CONTENT_NAVIGATOR_ID = "com.modeliosoft.modelio.mda.MdaExplorerContentID";
    public static final String VIEW_ID = "com.modeliosoft.modelio.mda.MdaExplorerContentID";
    protected IElement input = null;
    protected IElement rootInput = null;
    private MdaExplorerActionsManager actionsManager;
    private MdaExplorerActivateSender activateSender;
    private MdaExplorerContentProvider contentProvider;
    private MdaExplorerPickingManager explorerPickingManager;
    private MdaExplorerLabelProvider labelProvider;
    private IModelingSession modelingSession;
    private ElementNameModifier nameModifier;
    private SelectionHistory selectionHistory;
    private MdaExplorerNavigateListener umlExplorerNavigateListener;
    private MdaTreeViewerListener umlTreelistener;
    private MdaExplorerViewUpdater viewUpdater = null;
    private MdaExplorerModelChangeListener modelChangeListener;
    private MdaExplorerEditorActivationStrategy actSupport = null;
    private Clipboard clipboard;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getCommonViewer().setSorter(null);
        this.getCommonViewer().setAutoExpandLevel(1);
        INavigatorContentService contentService = this.getCommonViewer().getNavigatorContentService();
        INavigatorContentExtension contentExtension = contentService.getContentExtensionById(this.getContentProviderId());
        this.contentProvider = (MdaExplorerContentProvider)contentExtension.getContentProvider();
        this.labelProvider = new MdaExplorerLabelProvider();
        this.getCommonViewer().setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MdaStyledLabelProviderAdapter((ILabelProvider)this.labelProvider), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.initEditor();
        this.initApplicationEvents();
        this.explorerPickingManager = new MdaExplorerPickingManager(this);
        this.umlTreelistener = new MdaTreeViewerListener(this);
        this.getCommonViewer().addTreeListener((ITreeViewerListener)this.umlTreelistener);
        this.setTitleToolTip("");
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
    }

    public void disableNavigationListener() {
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.removeNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
    }

    public void dispose() {
        if (this.modelingSession != null) {
            this.sessionClosed(this.modelingSession);
        }
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.removeNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
        if (this.explorerPickingManager != null) {
            this.explorerPickingManager.dispose();
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        super.dispose();
    }

    public void enableNavigationListener() {
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.addNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
    }

    public MdaExplorerActionsManager getActionsManager() {
        return this.actionsManager;
    }

    public MdaExplorerContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IElement getInput() {
        return this.input;
    }

    public IElement getRootInput() {
        return this.rootInput;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.viewUpdater = new MdaExplorerViewUpdater(this);
        this.modelChangeListener = new MdaExplorerModelChangeListener(this);
        this.selectionHistory = new SelectionHistory(this);
        this.initActionsManager();
        IContextService contextService = (IContextService)this.getViewSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.bindings.context.MdaExplorerViewID");
        this.getViewSite().getActionBars().getMenuManager().removeAll();
        this.getViewSite().getActionBars().getMenuManager().update();
        this.clipboard = new Clipboard(Display.getCurrent());
    }

    public void selectElement(IElement element) {
        ModelElementAdapter adapter;
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        if (this.isSecondaryLink(element)) {
            DependencyContainerAdapter dependencyAdapter;
            IElement parentElement = element.getCompositionOwner();
            this.setExpandedState(parentElement, true);
            ModelElementAdapter parentAdapter = adaptersCache.getAdapter(parentElement);
            if (parentAdapter != null && (dependencyAdapter = parentAdapter.getDependencyAdapter()) != null) {
                viewer.setExpandedState((Object)dependencyAdapter, true);
            }
        }
        if ((adapter = adaptersCache.getAdapter(element)) != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)adapter), true);
        } else {
            IElement parentElement = element.getCompositionOwner();
            if (parentElement != null && !(parentElement instanceof IProject)) {
                this.setExpandedState(parentElement, true);
                adapter = adaptersCache.getAdapter(element);
                if (adapter != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)adapter), true);
                }
            }
        }
    }

    public void selectElements(List<IElement> elements) {
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        ArrayList<ModelElementAdapter> adaptersToSelect = new ArrayList<ModelElementAdapter>();
        for (IElement element : elements) {
            ModelElementAdapter adapter = adaptersCache.getAdapter(element);
            if (adapter != null) {
                adaptersToSelect.add(adapter);
                continue;
            }
            IElement parentElement = element.getCompositionOwner();
            if (parentElement == null || parentElement instanceof IProject) continue;
            this.setExpandedState(parentElement, true);
            adapter = adaptersCache.getAdapter(element);
            if (adapter == null) continue;
            adaptersToSelect.add(adapter);
        }
        viewer.setSelection((ISelection)new StructuredSelection(adaptersToSelect), true);
    }

    public void sessionClosed(IModelingSession session) {
        this.viewUpdater.stop();
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
        this.modelingSession.getModel().removeStatusListener((IStatusChangeListener)this.modelChangeListener);
        Tree tree = this.getCommonViewer().getTree();
        if (!tree.isDisposed()) {
            tree.removeMouseListener((MouseListener)this.actSupport);
        }
        if (!tree.isDisposed()) {
            tree.removeSelectionListener((SelectionListener)this.selectionHistory);
        }
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this.selectionHistory);
        IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
        pickingService.removePickingProvider((IPickingProvider)this.explorerPickingManager);
        this.modelingSession = null;
        if (!tree.isDisposed()) {
            this.setRootInput(null);
        }
    }

    public void sessionOpened(IModelingSession session) {
        if (this.modelingSession == null) {
            this.modelingSession = session;
            this.viewUpdater.start(this.modelingSession);
            this.modelingSession.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
            this.modelingSession.getModel().addStatusListener((IStatusChangeListener)this.modelChangeListener);
            IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
            pickingService.addPickingProvider((IPickingProvider)this.explorerPickingManager);
            this.getCommonViewer().getTree().addSelectionListener((SelectionListener)this.selectionHistory);
            this.modelingSession.getModel().addModelListener((IModelChangeListener)this.selectionHistory);
            this.getCommonViewer().getTree().addMouseListener((MouseListener)this.actSupport);
            this.setRootInput((IElement)session.getModel().getProject());
        }
    }

    public void setExpandedState(IElement element, boolean expanded) {
        CommonViewer viewer = this.getCommonViewer();
        ModelElementAdapterCache adaptersCache = this.getContentProvider().getAdaptersCache();
        ModelElementAdapter adapter = adaptersCache.getAdapter(element);
        if (adapter != null) {
            viewer.setExpandedState((Object)adapter, expanded);
        } else {
            IElement parentElement = element.getCompositionOwner();
            if (parentElement != null && !(parentElement instanceof IProject)) {
                this.setExpandedState(parentElement, true);
            } else {
                RootElementAdapter rootAdapter;
                List children;
                Object viewerInput = viewer.getInput();
                if (viewerInput instanceof RootElementAdapter && (children = (rootAdapter = (RootElementAdapter)viewerInput).getChildrenAdapters()).size() > 0) {
                    viewer.setExpandedState(children.get(0), expanded);
                }
            }
            adapter = adaptersCache.getAdapter(element);
            if (adapter != null) {
                viewer.setExpandedState((Object)adapter, expanded);
            }
        }
    }

    public void setInput(IElement element) {
        this.input = element;
        this.getCommonViewer().setInput((Object)new RootElementAdapter(this.input));
    }

    public void setRootInput(IElement element) {
        this.input = element;
        this.rootInput = element;
        if (element == null) {
            this.getCommonViewer().setInput(null);
        } else {
            this.getCommonViewer().setInput((Object)new RootElementAdapter(this.rootInput));
        }
    }

    protected String getContentProviderId() {
        return "com.modeliosoft.modelio.mda.MdaExplorerContentID";
    }

    protected IAdaptable getInitialInput() {
        return null;
    }

    private void initActionsManager() {
        this.actionsManager = new MdaExplorerActionsManager(this);
    }

    private void initApplicationEvents() {
        this.umlExplorerNavigateListener = new MdaExplorerNavigateListener(this);
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.addNavigationListener((INavigationListener)this.umlExplorerNavigateListener);
        this.activateSender = new MdaExplorerActivateSender(this);
        this.getCommonViewer().getTree().addMouseListener((MouseListener)this.activateSender);
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[1];
        TextCellEditor editor = new TextCellEditor((Composite)this.getCommonViewer().getTree(), 0);
        editor.getControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        cellEditors[0] = editor;
        this.getCommonViewer().setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.getCommonViewer().setColumnProperties(properties);
        this.nameModifier = new ElementNameModifier(this);
        this.getCommonViewer().setCellModifier((ICellModifier)this.nameModifier);
        this.actSupport = new MdaExplorerEditorActivationStrategy((ColumnViewer)this.getCommonViewer());
        TreeViewerEditor.create((TreeViewer)this.getCommonViewer(), null, (ColumnViewerEditorActivationStrategy)this.actSupport, (int)58);
    }

    private boolean isSecondaryLink(IElement element) {
        return element instanceof IDependency || element instanceof IElementImport || element instanceof IPackageImport || element instanceof IUsage || element instanceof IPackageMerge;
    }
}

