/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeEvent;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.CommandContributionItem;

public class MdaExplorerViewUpdater
implements IModelChangeListener,
IStatusChangeListener,
ISelectionListener {
    private IModelingSession modelingSession;
    private MdaExplorerView navigatorView;

    public MdaExplorerViewUpdater(MdaExplorerView navigatorView) {
        this.navigatorView = navigatorView;
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this.navigatorView) {
            this.updateToolbar();
            this.updateActionState((List)this.getSelectedElements(selection));
        }
    }

    public void start(IModelingSession aModelingSession) {
        this.modelingSession = aModelingSession;
        this.navigatorView.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.modelingSession.getModel().addModelListener((IModelChangeListener)this);
        this.modelingSession.getModel().addStatusListener((IStatusChangeListener)this);
    }

    public void statusChanged(IModelingSession session, IStatusChangeEvent event) {
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void stop() {
        this.navigatorView.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.modelingSession.getModel().removeModelListener((IModelChangeListener)this);
        this.modelingSession.getModel().removeStatusListener((IStatusChangeListener)this);
        this.modelingSession = null;
    }

    private boolean containsReadonlyElement(List<IElement> selectedElements) {
        for (IElement element : selectedElements) {
            if (!element.isValid()) {
                return true;
            }
            IElementStatus elementStatus = this.modelingSession.getElementStatus(element);
            if (elementStatus.isModifiable()) continue;
            return true;
        }
        return false;
    }

    private ArrayList<IElement> getSelectedElements() {
        ISelectionProvider selectionProvider = this.navigatorView.getViewSite().getSelectionProvider();
        if (selectionProvider != null) {
            return this.getSelectedElements(selectionProvider.getSelection());
        }
        return new ArrayList<IElement>(0);
    }

    private ArrayList<IElement> getSelectedElements(ISelection selection) {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object obj : selectedObjects) {
                IAdaptable adapter = (IAdaptable)obj;
                selectedElements.add((IElement)adapter.getAdapter(IElement.class));
            }
        }
        return selectedElements;
    }

    private void updateActionState(List<IElement> selectedElements) {
        boolean enable = !this.containsReadonlyElement(selectedElements);
        this.navigatorView.getActionsManager().setModifyActionsEnabled(enable);
    }

    private void updateToolbar() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.navigatorView.getViewSite().getActionBars().getToolBarManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)item;
                commandItem.update();
            }
            ++n2;
        }
    }

    static /* synthetic */ void access$0(MdaExplorerViewUpdater mdaExplorerViewUpdater) {
        mdaExplorerViewUpdater.updateToolbar();
    }

    static /* synthetic */ ArrayList access$1(MdaExplorerViewUpdater mdaExplorerViewUpdater) {
        return mdaExplorerViewUpdater.getSelectedElements();
    }

    static /* synthetic */ void access$2(MdaExplorerViewUpdater mdaExplorerViewUpdater, List list) {
        mdaExplorerViewUpdater.updateActionState(list);
    }
}

