/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.views.history;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IElementDeletedEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.mda.explorer.model.ModelElementAdapter;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.views.MdaExplorerView;
import com.modeliosoft.modelio.mda.explorer.views.history.BackwardSelectionAction;
import com.modeliosoft.modelio.mda.explorer.views.history.ForwardSelectionAction;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;

public class SelectionHistory
implements IModelChangeListener,
SelectionListener {
    protected BackwardSelectionAction backwardSelectionAction;
    protected ListIterator<IElement> currentSelection = null;
    protected ForwardSelectionAction forwardSelectionAction;
    protected LinkedList<IElement> navigationHistory = new LinkedList();
    protected MdaExplorerView view;
    private boolean isForward;

    public SelectionHistory(MdaExplorerView view) {
        this.view = view;
        this.makeActions();
        this.backwardSelectionAction.setEnabled(false);
        this.forwardSelectionAction.setEnabled(false);
    }

    public BackwardSelectionAction getBackwardSelectionAction() {
        return this.backwardSelectionAction;
    }

    public ForwardSelectionAction getForwardSelectionAction() {
        return this.forwardSelectionAction;
    }

    public MdaExplorerView getView() {
        return this.view;
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        IElementDeletedEvent[] deletedEvents = event.getDeleteEvents();
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void selectNextSelection() {
        IElement element;
        if (!this.isForward && this.currentSelection.hasNext()) {
            this.currentSelection.next();
            this.isForward = true;
        }
        if (this.currentSelection.hasNext() && (element = (IElement)this.currentSelection.next()) != null) {
            this.view.selectElement(element);
        }
        if (this.currentSelection.hasPrevious()) {
            this.backwardSelectionAction.setEnabled(true);
        } else {
            this.backwardSelectionAction.setEnabled(false);
        }
        if (this.currentSelection.hasNext()) {
            this.forwardSelectionAction.setEnabled(true);
        } else {
            this.forwardSelectionAction.setEnabled(false);
        }
    }

    public void selectPreviousSelection() {
        IElement element;
        if (this.isForward && this.currentSelection.hasPrevious()) {
            this.currentSelection.previous();
            this.isForward = false;
        }
        if (this.currentSelection.hasPrevious() && (element = (IElement)this.currentSelection.previous()) != null) {
            this.view.selectElement(element);
        }
        if (this.currentSelection.hasPrevious()) {
            this.backwardSelectionAction.setEnabled(true);
        } else {
            this.backwardSelectionAction.setEnabled(false);
        }
        if (this.currentSelection.hasNext()) {
            this.forwardSelectionAction.setEnabled(true);
        } else {
            this.forwardSelectionAction.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.handleSelection(event);
    }

    public void widgetSelected(SelectionEvent event) {
        this.handleSelection(event);
    }

    protected void handleSelection(SelectionEvent event) {
        TreeItem treeItem;
        Object data;
        Widget widget = event.widget;
        if (widget instanceof Tree) {
            Tree tree = (Tree)widget;
            if (tree.getSelectionCount() != 1) {
                return;
            }
        } else {
            return;
        }
        Widget item = event.item;
        if (item instanceof TreeItem && (data = (treeItem = (TreeItem)item).getData()) instanceof ModelElementAdapter) {
            ModelElementAdapter adapter = (ModelElementAdapter)data;
            IElement element = adapter.getElement();
            if (this.currentSelection != null) {
                int pos = this.currentSelection.nextIndex();
                this.removeAfter(pos);
            }
            if (this.navigationHistory.size() == 0 || this.navigationHistory.size() > 0 && !((IElement)this.navigationHistory.peekLast()).equals((Object)element)) {
                this.addElement(element);
            }
            int index = this.navigationHistory.lastIndexOf(element);
            this.currentSelection = this.navigationHistory.listIterator(index);
            this.isForward = false;
            this.forwardSelectionAction.setEnabled(false);
            if (this.navigationHistory.size() > 1) {
                this.backwardSelectionAction.setEnabled(true);
            }
        }
    }

    private void addElement(IElement element) {
        if (this.navigationHistory.size() == 20) {
            this.navigationHistory.removeFirst();
        }
        this.navigationHistory.offerLast(element);
    }

    private void makeActions() {
        this.makeBackwardSelectionAction();
        this.makeForwardSelectionAction();
        this.view.getViewSite().getActionBars().getToolBarManager().add((IAction)this.backwardSelectionAction);
        this.view.getViewSite().getActionBars().getToolBarManager().add((IAction)this.forwardSelectionAction);
    }

    private void makeBackwardSelectionAction() {
        IHandlerService handlerService = null;
        if (this.view != null) {
            handlerService = (IHandlerService)this.view.getSite().getService(IHandlerService.class);
        }
        ImageDescriptor image = null;
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.mda.explorer");
        Path bitmapPath = new Path("icons/backward_16.png");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        image = ImageDescriptor.createFromURL((URL)bitmapUrl);
        String label = MdaExplorer.I18N.getString("BackwardSelection");
        this.backwardSelectionAction = new BackwardSelectionAction(this, label, image);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.BackwardSelectionCommandID", (IHandler)new ActionHandler((IAction)this.backwardSelectionAction));
        }
    }

    private void makeForwardSelectionAction() {
        IHandlerService handlerService = null;
        if (this.view != null) {
            handlerService = (IHandlerService)this.view.getSite().getService(IHandlerService.class);
        }
        ImageDescriptor image = null;
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.mda.explorer");
        Path bitmapPath = new Path("icons/forward_16.png");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        image = ImageDescriptor.createFromURL((URL)bitmapUrl);
        String label = MdaExplorer.I18N.getString("ForwardSelection");
        this.forwardSelectionAction = new ForwardSelectionAction(this, label, image);
        if (handlerService != null) {
            handlerService.activateHandler("com.modeliosoft.modelio.explorer.ForwardSelectionCommandID", (IHandler)new ActionHandler((IAction)this.forwardSelectionAction));
        }
    }

    private void removeAfter(int index) {
        while (this.navigationHistory.size() > index + 1) {
            this.navigationHistory.removeLast();
        }
    }

    static /* synthetic */ void access$0(SelectionHistory selectionHistory, boolean bl) {
        selectionHistory.isForward = bl;
    }
}

