/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.notetype;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.notetype.NoteTypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.notetype.NoteTypeCreationDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateNoteTypeHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return MdaExplorer.getInstance().getModelingSession() != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        O.getDefault().getPickingProviderService().abortPicking();
        NoteTypeCreationDataModel dataModel = this.promptUser();
        if (dataModel != null) {
            try {
                this.createNoteType(dataModel);
            }
            catch (NoteTypeNotFoundException e) {
                throw new ExecutionException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private NoteTypeCreationDataModel promptUser() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NoteTypeCreationDataModel dataModel = new NoteTypeCreationDataModel();
        NoteTypeCreationDialog dialog = new NoteTypeCreationDialog(parentShell, dataModel);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private void createNoteType(NoteTypeCreationDataModel dataModel) throws NoteTypeNotFoundException {
        IProfile localProfile = this.getLocalProfile();
        if (localProfile == null) {
            return;
        }
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Create NoteType");
        try {
            try {
                IMetaclassReference metaclassRef = this.getModelElementRef(localProfile);
                IModelFactory factory = modelingSession.getModelFactory();
                if (metaclassRef == null) {
                    metaclassRef = factory.createMetaclassReference();
                    metaclassRef.setReferencedClassName("ModelElement");
                    localProfile.addOwnedReference(metaclassRef);
                }
                INoteType noteType = factory.createNoteType();
                noteType.setName(dataModel.getNoteTypeName());
                metaclassRef.addDefinedNoteType(noteType);
                String noteTypeDescription = dataModel.getNoteTypeDescription();
                if (noteTypeDescription != null && !noteTypeDescription.equals("")) {
                    factory.createNote("description", (IModelElement)noteType, noteTypeDescription);
                }
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private IMetaclassReference getModelElementRef(IProfile profile) {
        ObList metaclassRefs = profile.getOwnedReference();
        for (IMetaclassReference metaclassRef : metaclassRefs) {
            if (metaclassRef.getReferenced() != null && metaclassRef.getReferenced().getName().equals("ModelElement")) {
                return metaclassRef;
            }
            if (metaclassRef.getReferencedClassName() == null || !metaclassRef.getReferencedClassName().equals("ModelElement")) continue;
            return metaclassRef;
        }
        return null;
    }

    private IProfile getLocalProfile() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IProject project = modelingSession.getModel().getProject();
        ObList modules = project.getInstalled();
        for (IModule module : modules) {
            if (!module.getName().equals("LocalModule")) continue;
            ObList profiles = module.getOwnedProfile();
            for (IProfile profile : profiles) {
                if (!profile.getName().equals("LocalProfile")) continue;
                return profile;
            }
        }
        return null;
    }
}

