/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.notetype;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.notetype.NoteTypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.notetype.NoteTypeCreationDialog;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class NoteTypeNameListener
implements ModifyListener {
    private NoteTypeCreationDialog dialog = null;
    private NoteTypeCreationDataModel dataModel = null;
    private static final Pattern NoteTypeNameNamePattern = Pattern.compile("[\\p{L}\\p{N}\\._ ]+");

    public NoteTypeNameListener(NoteTypeCreationDialog dialog, NoteTypeCreationDataModel dataModel) {
        this.dialog = dialog;
        this.dataModel = dataModel;
    }

    public void modifyText(ModifyEvent e) {
        String noteTypeName = this.dialog.noteTypeNameText.getText();
        if (noteTypeName != null && !noteTypeName.equals("") && this.validateNoteTypeName(noteTypeName) && !this.noteTypeNameExists(noteTypeName)) {
            this.dialog.invalidateNoteTypeNameText(false);
            this.dialog.createButton.setEnabled(true);
        } else {
            this.dialog.invalidateNoteTypeNameText(true);
            this.dialog.createButton.setEnabled(false);
        }
        this.dataModel.setNoteTypeName(noteTypeName);
    }

    private boolean noteTypeNameExists(String noteTypeName) {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IProject project = modelingSession.getModel().getProject();
        try {
            project.getNoteType(IModelElement.class, noteTypeName);
            return true;
        }
        catch (NoteTypeNotFoundException e) {
            return false;
        }
    }

    protected boolean validateNoteTypeName(String name) {
        return NoteTypeNameNamePattern.matcher(name).matches();
    }
}

