/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.stereotype;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDialog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class BrowserIconChooser
implements SelectionListener {
    private StereotypeCreationDialog dialog = null;
    private StereotypeCreationDataModel dataModel = null;
    private IModelingSession modelingSession = null;

    public BrowserIconChooser(StereotypeCreationDialog dialog, IModelingSession modelingSession, StereotypeCreationDataModel dataModel) {
        this.dialog = dialog;
        this.dataModel = dataModel;
        this.modelingSession = modelingSession;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.selectImage(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectImage(e);
    }

    private void selectImage(SelectionEvent e) {
        FileDialog fileDialog = new FileDialog(this.dialog.getShell(), 4096);
        String[] filterNames = new String[]{MdaExplorer.I18N.getString("StereotypeCreationDialog.ImageFiles")};
        String[] filterExtensions = new String[]{"*.png;*.bmp"};
        String projectPath = this.modelingSession.getProjectSpacePath().getPath();
        fileDialog.setFilterNames(filterNames);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterPath(projectPath);
        String imagePath = fileDialog.open();
        if (imagePath != null) {
            this.setBrowserIcon(imagePath);
        }
        this.dialog.refresh();
    }

    void setBrowserIcon(String imagePath) {
        File imageFile = new File(imagePath);
        if (imageFile.isFile()) {
            ImageDescriptor explorerIconDesc = null;
            try {
                explorerIconDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            if (explorerIconDesc != null) {
                ImageData explorerIconData = explorerIconDesc.getImageData();
                if (explorerIconData.width <= 16 && explorerIconData.height <= 16) {
                    this.dataModel.setExplorerIcon(imagePath);
                } else {
                    MessageDialog.openError((Shell)this.dialog.getShell(), (String)MdaExplorer.I18N.getString("BrowserIconChooser.ImageIsTooBig.Title"), (String)MdaExplorer.I18N.getMessage("BrowserIconChooser.ImageIsTooBig.Message", new String[]{imagePath}));
                }
            }
        }
    }
}

