/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.stereotype;

import com.modeliosoft.modelio.api.model.extension.IConfigParam;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDialog;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeMessageDialog;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.LocalModuleCreator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateStereotypeCommand {
    public IStereotype execute(List<IModelElement> selectedElements, boolean showApplyStereotype) {
        O.getDefault().getPickingProviderService().abortPicking();
        StereotypeCreationDataModel dataModel = this.promptUser(selectedElements, showApplyStereotype);
        IStereotype stereotype = null;
        if (dataModel != null) {
            stereotype = this.createStereotype(selectedElements, dataModel);
        }
        return stereotype;
    }

    private StereotypeCreationDataModel promptUser(List<IModelElement> elements, boolean showApplyStereotype) {
        IElementStatus status;
        boolean show = showApplyStereotype;
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IModelElement element = null;
        if (elements.size() == 1) {
            element = elements.get(0);
        }
        String metaclassName = null;
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        if (element == null || element instanceof IModule || element instanceof IProfile || element instanceof IProject || element instanceof ITagType || element instanceof INoteType || element instanceof IStereotype || element instanceof IConfigParam) {
            metaclassName = "ModelElement";
            if (modelingSession != null && element != null) {
                status = element.getElementStatus();
                if (show) {
                    show = status.isModifiable();
                }
            }
        } else {
            metaclassName = element.getMetaclassName();
            if (modelingSession != null) {
                status = element.getElementStatus();
                if (show) {
                    show = status.isModifiable();
                }
            }
        }
        StereotypeCreationDataModel dataModel = new StereotypeCreationDataModel(metaclassName, null);
        dataModel.setApplyStereotype(show);
        StereotypeCreationDialog dialog = new StereotypeCreationDialog(parentShell, dataModel);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private IStereotype createStereotype(List<IModelElement> selectedElements, StereotypeCreationDataModel dataModel) {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IModelFactory factory = modelingSession.getModelFactory();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = null;
        IStereotype stereotype = null;
        try {
            IProfile ownerProfile;
            transaction = transactionManager.createTransaction("Create Stereotype");
            IModule localModule = this.getLocalModule();
            if (localModule == null) {
                LocalModuleCreator localModuleCreator = new LocalModuleCreator(modelingSession);
                localModuleCreator.execute();
                localModule = this.getLocalModule();
            }
            if ((ownerProfile = selectedElements.size() == 1 && selectedElements.get(0) instanceof IProfile ? (IProfile)selectedElements.get(0) : this.getLocalProfile()) == null) {
                IProfile profile = factory.createProfile();
                profile.setName("LocalProfile");
                localModule.addOwnedProfile(profile);
                this.writeLocalModuleProperties(modelingSession.getProjectSpacePath());
                ownerProfile = profile;
            }
            stereotype = factory.createStereotype();
            stereotype.setName(dataModel.getStereotypeName());
            stereotype.setLabel(dataModel.getStereotypeName());
            stereotype.setBaseClassName(dataModel.getMetaclassName());
            this.setIconsPathes(dataModel, stereotype);
            ownerProfile.addDefinedStereotype(stereotype);
            if (dataModel.isApplyStereotype()) {
                this.addStereotypeOnSelectedElements(stereotype, selectedElements, dataModel);
            }
            transactionManager.commit(transaction);
            transaction = null;
            IStereotype iStereotype = stereotype;
            return iStereotype;
        }
        catch (InvalidTransactionException e) {
            transaction = null;
            e.printStackTrace();
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return stereotype;
    }

    private IProfile getLocalProfile() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IProject project = modelingSession.getModel().getProject();
        ObList modules = project.getInstalled();
        for (IModule module : modules) {
            if (!module.getName().equals("LocalModule")) continue;
            ObList profiles = module.getOwnedProfile();
            for (IProfile profile : profiles) {
                if (!profile.getName().equals("LocalProfile")) continue;
                return profile;
            }
        }
        return null;
    }

    private File copy(File in, File out) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        if (!in.equals(out)) {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        return out;
    }

    private void setIconsPathes(StereotypeCreationDataModel dataModel, IStereotype stereotype) {
        boolean copyFiles;
        String explorerIconPath = dataModel.getExplorerIcon();
        String diagramImagePath = dataModel.getDiagramImage();
        File explorerIconFile = new File(explorerIconPath);
        File diagramImageFile = new File(diagramImagePath);
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        String projectPath = modelingSession.getWorkspacePath().getPath();
        File projectDirectory = new File(projectPath);
        File destinationDirectory = new File(projectDirectory, "/mda/LocalModule/res/bmp");
        HashSet<File> filesToCopy = new HashSet<File>();
        if (explorerIconFile.exists() && !explorerIconFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(explorerIconFile);
        }
        if (diagramImageFile.exists() && !diagramImageFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(diagramImageFile);
        }
        StringBuffer filesAlreadyExistsMsg = new StringBuffer();
        HashSet<File> filesAlreadyExists = new HashSet<File>();
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            if (!destinationFile.exists()) continue;
            filesAlreadyExists.add(file);
            filesAlreadyExistsMsg.append("- ");
            filesAlreadyExistsMsg.append(destinationFile.getAbsolutePath());
            filesAlreadyExistsMsg.append(Text.DELIMITER);
        }
        if (filesAlreadyExistsMsg.length() > 0 && !(copyFiles = StereotypeMessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.FileAlreadyExists.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.FileAlreadyExists.Message", new String[]{filesAlreadyExistsMsg.toString(), destinationDirectory.getAbsolutePath()})))) {
            for (File filesAlreadyExist : filesAlreadyExists) {
                filesToCopy.remove(filesAlreadyExist);
            }
        }
        ArrayList<File> filesIOException = new ArrayList<File>();
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            try {
                this.copy(file, destinationFile);
            }
            catch (IOException e) {
                filesIOException.add(file);
                e.printStackTrace();
            }
        }
        if (filesIOException.size() > 0) {
            StringBuffer filesErrorsMsg = new StringBuffer();
            for (File file : filesIOException) {
                filesErrorsMsg.append("- ");
                filesErrorsMsg.append(file.getAbsolutePath());
                filesErrorsMsg.append(Text.DELIMITER);
            }
            StereotypeMessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.IOException.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.IOException.Message", new String[]{filesErrorsMsg.toString()}));
        }
        if (explorerIconFile.exists()) {
            stereotype.setIconBrowser("LocalModule/res/bmp/" + explorerIconFile.getName());
        }
        if (diagramImageFile.exists()) {
            stereotype.setIcon("LocalModule/res/bmp/" + diagramImageFile.getName());
        }
    }

    private void addStereotypeOnSelectedElements(IStereotype stereotype, List<IModelElement> selectedElements, StereotypeCreationDataModel dataModel) {
        Class metaclass = this.getMetaclass(dataModel.getMetaclassName());
        if (metaclass == null) {
            return;
        }
        for (IModelElement element : selectedElements) {
            if (element instanceof IProfile || !metaclass.isAssignableFrom(element.getClass())) continue;
            element.addExtension(stereotype);
        }
    }

    private Class<?> getMetaclass(String stereotypeMetaclass) {
        try {
            return MetaModelExpert.getMetaclass((String)stereotypeMetaclass);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void writeLocalModuleProperties(File projectDirectory) {
        BufferedWriter out;
        File localModuleDirectory = new File(projectDirectory, "mda/LocalModule");
        File manifestCommonFile = new File(localModuleDirectory, "module.properties");
        File manifestFrFile = new File(localModuleDirectory, "module_fr.properties");
        localModuleDirectory.mkdirs();
        Date date = new Date();
        try {
            out = new BufferedWriter(new FileWriter(manifestCommonFile));
            out.write("#Generated by Modelio\n");
            out.write("#");
            out.write(DateFormat.getInstance().format(date));
            out.write("\n");
            out.write("MdacLabel=Local module\n");
            out.write("MdacDescription=The local module constains all the UML extensions defined by the user of the project.\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out = new BufferedWriter(new FileWriter(manifestFrFile));
            out.write("#Generated by Modelio\n");
            out.write("#");
            out.write(DateFormat.getInstance().format(date));
            out.write("\n");
            out.write("MdacLabel=Module local\n");
            out.write("MdacDescription=Le module local contient les extensions UML d\u00c3\u00a9finies par l'utilisateur du projet.\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IModule getLocalModule() {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IProject project = modelingSession.getModel().getProject();
        ObList modules = project.getInstalled();
        for (IModule module : modules) {
            if (!module.getName().equals("LocalModule")) continue;
            return module;
        }
        return null;
    }
}

