/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.stereotype;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDialog;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeMessageDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditStereotypeCommand {
    public IStereotype execute(IStereotype editedStereotype) {
        O.getDefault().getPickingProviderService().abortPicking();
        StereotypeCreationDataModel dataModel = this.promptUser(editedStereotype);
        IStereotype stereotype = null;
        if (dataModel != null) {
            this.editStereotype(editedStereotype, dataModel);
        }
        return stereotype;
    }

    private StereotypeCreationDataModel promptUser(IStereotype editedStereotype) {
        File iconBrowserPath;
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        String projectPath = modelingSession.getProjectSpacePath().getPath();
        File projectDirectory = new File(projectPath);
        File destinationDirectory = new File(projectDirectory + "/mda/");
        StereotypeCreationDataModel dataModel = new StereotypeCreationDataModel(editedStereotype.getBaseClassName(), editedStereotype);
        dataModel.setStereotypeName(editedStereotype.getName());
        File iconPath = new File(destinationDirectory, editedStereotype.getIcon());
        if (iconPath.isFile()) {
            dataModel.setDiagramImage(iconPath.getAbsolutePath());
        }
        if ((iconBrowserPath = new File(destinationDirectory, editedStereotype.getIconBrowser())).isFile()) {
            dataModel.setExplorerIcon(iconBrowserPath.getAbsolutePath());
        }
        StereotypeCreationDialog dialog = new StereotypeCreationDialog(parentShell, dataModel);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private void editStereotype(IStereotype editedStereotype, StereotypeCreationDataModel dataModel) {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = null;
        try {
            try {
                transaction = transactionManager.createTransaction("Edit Stereotype");
                editedStereotype.setName(dataModel.getStereotypeName());
                editedStereotype.setLabel(dataModel.getStereotypeName());
                editedStereotype.setBaseClassName(dataModel.getMetaclassName());
                this.setIconsPaths(dataModel, editedStereotype);
                transactionManager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                e.printStackTrace();
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private File copy(File in, File out) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        if (!in.equals(out)) {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        return out;
    }

    private void setIconsPaths(StereotypeCreationDataModel dataModel, IStereotype stereotype) {
        boolean copyFiles;
        String explorerIconPath = dataModel.getExplorerIcon();
        String diagramImagePath = dataModel.getDiagramImage();
        File explorerIconFile = new File(explorerIconPath);
        File diagramImageFile = new File(diagramImagePath);
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        String projectPath = modelingSession.getWorkspacePath().getPath();
        File projectDirectory = new File(projectPath);
        File destinationDirectory = new File(projectDirectory, "/mda/LocalModule/res/bmp");
        HashSet<File> filesToCopy = new HashSet<File>();
        if (explorerIconFile.exists() && !explorerIconFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(explorerIconFile);
        }
        if (diagramImageFile.exists() && !diagramImageFile.getParentFile().equals(destinationDirectory)) {
            filesToCopy.add(diagramImageFile);
        }
        StringBuffer filesAlreadyExistsMsg = new StringBuffer();
        HashSet<File> filesAlreadyExists = new HashSet<File>();
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            if (!destinationFile.exists()) continue;
            filesAlreadyExists.add(file);
            filesAlreadyExistsMsg.append("- ");
            filesAlreadyExistsMsg.append(destinationFile.getAbsolutePath());
            filesAlreadyExistsMsg.append(Text.DELIMITER);
        }
        if (filesAlreadyExistsMsg.length() > 0 && !(copyFiles = StereotypeMessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.FileAlreadyExists.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.FileAlreadyExists.Message", new String[]{filesAlreadyExistsMsg.toString(), destinationDirectory.getAbsolutePath()})))) {
            for (File filesAlreadyExist : filesAlreadyExists) {
                filesToCopy.remove(filesAlreadyExist);
            }
        }
        ArrayList<File> filesIOException = new ArrayList<File>();
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        for (File file : filesToCopy) {
            File destinationFile = new File(destinationDirectory, file.getName());
            try {
                this.copy(file, destinationFile);
            }
            catch (IOException e) {
                filesIOException.add(file);
                e.printStackTrace();
            }
        }
        if (filesIOException.size() > 0) {
            StringBuffer filesErrorsMsg = new StringBuffer();
            for (File file : filesIOException) {
                filesErrorsMsg.append("- ");
                filesErrorsMsg.append(file.getAbsolutePath());
                filesErrorsMsg.append(Text.DELIMITER);
            }
            StereotypeMessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MdaExplorer.I18N.getString("StereotypeCreationDialog.IOException.Title"), (String)MdaExplorer.I18N.getMessage("StereotypeCreationDialog.IOException.Message", new String[]{filesErrorsMsg.toString()}));
        }
        if (explorerIconFile.exists()) {
            stereotype.setIconBrowser("LocalModule/res/bmp/" + explorerIconFile.getName());
        }
        if (diagramImageFile.exists()) {
            stereotype.setIcon("LocalModule/res/bmp/" + diagramImageFile.getName());
        }
    }
}

