/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.stereotype;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.ApplyStereotypeListener;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.BrowserIconChooser;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.DiagramImageChooser;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeValidator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * Exception performing whole class analysis ignored.
 */
public class StereotypeCreationDialog
extends ModelioDialog {
    private StereotypeCreationDataModel dataModel = null;
    private StereotypeValidator stereotypeValidator = null;
    private IModelingSession modelingSession = null;
    private ApplyStereotypeListener applyStereotypeListener = null;
    private BrowserIconChooser explorerIconChooser = null;
    private DiagramImageChooser diagramImageChooser = null;
    protected Button createButton = null;
    protected Text stereotypeNameText = null;
    protected Label explorerIconImage = null;
    protected Label diagramImageImage = null;
    protected Combo metaclassCombo = null;
    private Image fileChooserImage = null;
    private ImageRegistry imageRegistry = null;
    private Font sizeFontAdvice = null;
    protected Button applyStereotypeCheckbox = null;
    private Button explorerIconButton = null;
    private Button diagramImageButton = null;

    public StereotypeCreationDialog(Shell parentShell, StereotypeCreationDataModel dataModel) {
        super(parentShell);
        this.dataModel = dataModel;
        this.fileChooserImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.mda.explorer", (String)"icons/file_chooser.png").createImage();
        this.modelingSession = MdaExplorer.getInstance().getModelingSession();
        this.imageRegistry = new ImageRegistry();
        this.sizeFontAdvice = new Font((Device)parentShell.getDisplay(), "Tahoma", 6, 2);
        this.setShellStyle(0x10860 | StereotypeCreationDialog.getDefaultOrientation());
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 0, this.dataModel.isCreationMode() ? MdaExplorer.I18N.getString("StereotypeCreationDialog.Create") : IDialogConstants.OK_LABEL, true);
        this.createButton.setEnabled(false);
        this.createButton(parent, 1, MdaExplorer.I18N.getString("StereotypeCreationDialog.Cancel"), false);
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(1808));
        this.createFieldArea(area);
        this.createImagesArea(area);
        if (this.dataModel.isCreationMode()) {
            this.createApplyStereotype(area);
        }
        return area;
    }

    public void init() {
        this.setLogoImage(null);
        if (this.dataModel.isCreationMode()) {
            this.getShell().setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.Title"));
            this.setTitle(MdaExplorer.I18N.getString("StereotypeCreationDialog.Title"));
            this.setMessage(MdaExplorer.I18N.getString("StereotypeCreationDialog.Message"));
        } else {
            this.getShell().setText(MdaExplorer.I18N.getString("StereotypeEditionDialog.Title"));
            this.setTitle(MdaExplorer.I18N.getString("StereotypeEditionDialog.Title"));
            this.setMessage(MdaExplorer.I18N.getString("StereotypeEditionDialog.Message"));
        }
        this.getShell().pack(true);
        this.refresh();
    }

    public void invalidateStereotypeNameText(boolean invalidate) {
        if (invalidate) {
            this.stereotypeNameText.setForeground(this.stereotypeNameText.getDisplay().getSystemColor(3));
        } else {
            this.stereotypeNameText.setForeground(this.stereotypeNameText.getDisplay().getSystemColor(6));
        }
    }

    public boolean close() {
        if (this.fileChooserImage != null) {
            this.fileChooserImage.dispose();
            this.fileChooserImage = null;
        }
        if (this.stereotypeValidator != null) {
            this.stereotypeNameText.removeModifyListener((ModifyListener)this.stereotypeValidator);
            this.metaclassCombo.removeModifyListener((ModifyListener)this.stereotypeValidator);
            this.stereotypeValidator = null;
        }
        if (this.applyStereotypeListener != null) {
            this.applyStereotypeCheckbox.removeSelectionListener((SelectionListener)this.applyStereotypeListener);
            this.applyStereotypeListener = null;
        }
        if (this.explorerIconButton != null) {
            this.explorerIconButton.removeSelectionListener((SelectionListener)this.explorerIconChooser);
            this.explorerIconButton = null;
        }
        if (this.diagramImageButton != null) {
            this.diagramImageButton.removeSelectionListener((SelectionListener)this.diagramImageChooser);
            this.diagramImageButton = null;
        }
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
        if (this.sizeFontAdvice != null) {
            this.sizeFontAdvice.dispose();
            this.sizeFontAdvice = null;
        }
        return super.close();
    }

    private void createDiagramImageArea(Composite area) {
        Composite diagramImageArea = new Composite(area, 0);
        GridLayout gl_diagramImageArea = new GridLayout(1, true);
        gl_diagramImageArea.verticalSpacing = 3;
        diagramImageArea.setLayout((Layout)gl_diagramImageArea);
        diagramImageArea.setLayoutData((Object)new GridData(1808));
        Composite imageArea = new Composite(diagramImageArea, 2048);
        GridLayout gl_imageArea = new GridLayout(1, true);
        gl_imageArea.marginHeight = 0;
        gl_imageArea.marginWidth = 0;
        imageArea.setLayout((Layout)gl_imageArea);
        GridData gd_imageArea = new GridData(0x1000000, 0x1000000, true, false);
        gd_imageArea.heightHint = 100;
        gd_imageArea.widthHint = 100;
        imageArea.setLayoutData((Object)gd_imageArea);
        this.diagramImageImage = new Label(imageArea, 0x1000000);
        this.diagramImageImage.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.NoImage"));
        GridData gd_diagramImageText = new GridData(0x1000000, 0x1000000, false, false);
        gd_diagramImageText.heightHint = 100;
        gd_diagramImageText.widthHint = 100;
        this.diagramImageImage.setLayoutData((Object)gd_diagramImageText);
        Label diagramImageSizeLabel = new Label(diagramImageArea, 0x1000000);
        diagramImageSizeLabel.setFont(this.sizeFontAdvice);
        diagramImageSizeLabel.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.DiagramImageSizeLabel"));
        GridData gd_diagramImageSizeLabel = new GridData(0x1000000, 0x1000000, true, false);
        gd_diagramImageSizeLabel.widthHint = 100;
        diagramImageSizeLabel.setLayoutData((Object)gd_diagramImageSizeLabel);
        this.diagramImageButton = new Button(diagramImageArea, 0x1000000);
        this.diagramImageButton.setImage(this.fileChooserImage);
        this.diagramImageButton.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.DiagramImageLabel"));
        this.diagramImageChooser = new DiagramImageChooser(this, this.modelingSession, this.dataModel);
        this.diagramImageButton.addSelectionListener((SelectionListener)this.diagramImageChooser);
        GridData gd_diagramImageButton = new GridData(0x1000000, 0x1000000, true, false);
        this.diagramImageButton.setLayoutData((Object)gd_diagramImageButton);
    }

    private void createExplorerIconArea(Composite area) {
        Composite explorerIconArea = new Composite(area, 0);
        GridLayout gl_explorerIconArea = new GridLayout(1, true);
        gl_explorerIconArea.verticalSpacing = 3;
        explorerIconArea.setLayout((Layout)gl_explorerIconArea);
        explorerIconArea.setLayoutData((Object)new GridData(1808));
        Composite imageArea = new Composite(explorerIconArea, 2048);
        GridLayout gl_imageArea = new GridLayout(1, true);
        gl_imageArea.marginHeight = 0;
        gl_imageArea.marginWidth = 0;
        imageArea.setLayout((Layout)gl_imageArea);
        GridData gd_imageArea = new GridData(0x1000000, 0x1000000, true, false);
        gd_imageArea.heightHint = 100;
        gd_imageArea.widthHint = 100;
        imageArea.setLayoutData((Object)gd_imageArea);
        this.explorerIconImage = new Label(imageArea, 0x1000000);
        this.explorerIconImage.setSize(100, 100);
        this.explorerIconImage.setImage(null);
        this.explorerIconImage.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.NoImage"));
        GridData gd_explorerIconImage = new GridData(0x1000000, 0x1000000, false, false);
        gd_explorerIconImage.heightHint = 100;
        gd_explorerIconImage.widthHint = 100;
        this.explorerIconImage.setLayoutData((Object)gd_explorerIconImage);
        Label explorerIconSizeLabel = new Label(explorerIconArea, 0x1000000);
        explorerIconSizeLabel.setFont(this.sizeFontAdvice);
        explorerIconSizeLabel.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.ExplorerIconSizeLabel"));
        GridData gd_explorerIconSizeLabel = new GridData(0x1000000, 0x1000000, true, false);
        gd_explorerIconSizeLabel.widthHint = 100;
        explorerIconSizeLabel.setLayoutData((Object)gd_explorerIconSizeLabel);
        this.explorerIconButton = new Button(explorerIconArea, 0);
        this.explorerIconButton.setImage(this.fileChooserImage);
        this.explorerIconButton.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.BrowserIconLabel"));
        this.explorerIconChooser = new BrowserIconChooser(this, this.modelingSession, this.dataModel);
        this.explorerIconButton.addSelectionListener((SelectionListener)this.explorerIconChooser);
        GridData gd_browserIconButton = new GridData(0x1000000, 0x1000000, true, false);
        this.explorerIconButton.setLayoutData((Object)gd_browserIconButton);
    }

    private void createMetaclassArea(Composite area) {
        Label metaclassLabel = new Label(area, 0);
        metaclassLabel.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.MetaclassLabel"));
        GridData gd_metaclassLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        metaclassLabel.setLayoutData((Object)gd_metaclassLabel);
        this.metaclassCombo = new Combo(area, 2048);
        List metaclasses = CompositionExpert.getMetaclasses((String)"ModelElement");
        metaclasses.remove("Module");
        metaclasses.remove("Profile");
        metaclasses.remove("Project");
        metaclasses.remove("TagType");
        metaclasses.remove("NoteType");
        metaclasses.remove("Stereotype");
        metaclasses.remove("ConfigParam");
        this.metaclassCombo.setItems(metaclasses.toArray(new String[metaclasses.size()]));
        this.metaclassCombo.setText(this.dataModel.getMetaclassName());
        this.metaclassCombo.addModifyListener((ModifyListener)this.stereotypeValidator);
        GridData gd_metaclassCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        this.metaclassCombo.setLayoutData((Object)gd_metaclassCombo);
    }

    private void createNameArea(Composite area) {
        Label docLabel = new Label(area, 64);
        docLabel.setForeground(UIColor.LABEL_TIP_FG);
        docLabel.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.DocLabel"));
        GridData gd_docLabel = new GridData(4, 128, true, false, 2, 1);
        gd_docLabel.widthHint = 400;
        docLabel.setLayoutData((Object)gd_docLabel);
        Label noteTypeNameLabel = new Label(area, 0);
        noteTypeNameLabel.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.NameLabel"));
        GridData gd_noteTypeNameLabel = new GridData(16384, 0x1000000, false, false);
        noteTypeNameLabel.setLayoutData((Object)gd_noteTypeNameLabel);
        this.stereotypeNameText = new Text(area, 2048);
        this.stereotypeValidator = new StereotypeValidator(this, this.dataModel);
        this.stereotypeNameText.addModifyListener((ModifyListener)this.stereotypeValidator);
        GridData gd_stereotypeNameText = new GridData(4, 0x1000000, true, false);
        this.stereotypeNameText.setLayoutData((Object)gd_stereotypeNameText);
    }

    public void refresh() {
        this.stereotypeNameText.setText(this.dataModel.getStereotypeName());
        this.metaclassCombo.setText(this.dataModel.getMetaclassName());
        String projectPath = this.modelingSession.getProjectSpacePath().getPath();
        File projectDirectory = new File(projectPath);
        File destinationDirectory = new File(projectDirectory, "/mda/LocalModule/res/bmp");
        String explorerIconPath = this.dataModel.getExplorerIcon();
        if (explorerIconPath != null && !explorerIconPath.equals("")) {
            Image explorerIcon = this.imageRegistry.get(explorerIconPath);
            if (explorerIcon == null) {
                File explorerIconFile = new File(explorerIconPath);
                try {
                    ImageDescriptor explorerIconDesc = ImageDescriptor.createFromURL((URL)explorerIconFile.toURI().toURL());
                    ImageData explorerIconData = explorerIconDesc.getImageData();
                    if (explorerIconData.width > 100 || explorerIconData.height > 100) {
                        ImageData data = this.scaleImage(explorerIconData);
                        explorerIconDesc = ImageDescriptor.createFromImageData((ImageData)data);
                    }
                    this.imageRegistry.put(explorerIconPath, explorerIconDesc);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                explorerIcon = this.imageRegistry.get(explorerIconPath);
            }
            this.explorerIconImage.setImage(explorerIcon);
            this.explorerIconImage.setToolTipText(MdaExplorer.I18N.getMessage("StereotypeCreationDialog.FilesWillBeCopied.Message", new String[]{explorerIconPath, destinationDirectory.getAbsolutePath()}));
        } else {
            this.explorerIconImage.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.NoImage"));
        }
        String diagramImagePath = this.dataModel.getDiagramImage();
        if (diagramImagePath != null && !diagramImagePath.equals("")) {
            Image diagramImage = this.imageRegistry.get(diagramImagePath);
            if (diagramImage == null) {
                File diagramImageFile = new File(diagramImagePath);
                try {
                    ImageDescriptor diagramImageDesc = ImageDescriptor.createFromURL((URL)diagramImageFile.toURI().toURL());
                    ImageData diagramImageData = diagramImageDesc.getImageData();
                    if (diagramImageData.width > 100 || diagramImageData.height > 100) {
                        ImageData data = this.scaleImage(diagramImageData);
                        diagramImageDesc = ImageDescriptor.createFromImageData((ImageData)data);
                    }
                    this.imageRegistry.put(diagramImagePath, diagramImageDesc);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                diagramImage = this.imageRegistry.get(diagramImagePath);
            }
            this.diagramImageImage.setImage(diagramImage);
            this.diagramImageImage.setToolTipText(MdaExplorer.I18N.getMessage("StereotypeCreationDialog.FilesWillBeCopied.Message", new String[]{diagramImagePath, destinationDirectory.getAbsolutePath()}));
        } else {
            this.diagramImageImage.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.NoImage"));
        }
    }

    public void invalidateExplorerIconText(boolean invalidate) {
        if (invalidate) {
            this.explorerIconImage.setForeground(this.explorerIconImage.getDisplay().getSystemColor(3));
        } else {
            this.explorerIconImage.setForeground(this.explorerIconImage.getDisplay().getSystemColor(6));
        }
    }

    public void invalidateDiagramImageText(boolean invalidate) {
        if (invalidate) {
            this.diagramImageImage.setForeground(this.diagramImageImage.getDisplay().getSystemColor(3));
        } else {
            this.diagramImageImage.setForeground(this.diagramImageImage.getDisplay().getSystemColor(6));
        }
    }

    private void createFieldArea(Composite area) {
        Composite fieldArea = new Composite(area, 0);
        fieldArea.setLayout((Layout)new GridLayout(2, false));
        fieldArea.setLayoutData((Object)new GridData(768));
        this.createNameArea(fieldArea);
        this.createMetaclassArea(fieldArea);
    }

    private void createImagesArea(Composite area) {
        Composite imageArea = new Composite(area, 0);
        GridLayout gl_imageArea = new GridLayout(2, true);
        gl_imageArea.horizontalSpacing = 0;
        gl_imageArea.verticalSpacing = 0;
        gl_imageArea.marginHeight = 0;
        gl_imageArea.marginWidth = 0;
        imageArea.setLayout((Layout)gl_imageArea);
        GridData gd_imageArea = new GridData(1808);
        imageArea.setLayoutData((Object)gd_imageArea);
        this.createExplorerIconArea(imageArea);
        this.createDiagramImageArea(imageArea);
    }

    private void createApplyStereotype(Composite area) {
        this.applyStereotypeCheckbox = new Button(area, 32);
        this.applyStereotypeCheckbox.setSelection(true);
        this.applyStereotypeCheckbox.setText(MdaExplorer.I18N.getString("StereotypeCreationDialog.ApplyStereotype"));
        this.applyStereotypeListener = new ApplyStereotypeListener(this, this.dataModel);
        this.applyStereotypeCheckbox.addSelectionListener((SelectionListener)this.applyStereotypeListener);
        GridData gd_applyStereotype = new GridData(16384, 0x1000000, true, false);
        this.applyStereotypeCheckbox.setLayoutData((Object)gd_applyStereotype);
    }

    private ImageData scaleImage(ImageData explorerIconData) {
        if (explorerIconData.height > explorerIconData.width) {
            int w = explorerIconData.width * 100 / explorerIconData.height;
            return explorerIconData.scaledTo(w, 100);
        }
        int h = explorerIconData.height * 100 / explorerIconData.width;
        return explorerIconData.scaledTo(100, h);
    }

    public void invalidateMetaclassNameText(boolean invalidate) {
        if (invalidate) {
            this.metaclassCombo.setForeground(this.metaclassCombo.getDisplay().getSystemColor(3));
        } else {
            this.metaclassCombo.setForeground(this.metaclassCombo.getDisplay().getSystemColor(6));
        }
    }
}

