/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.explorer.wizards.stereotype;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.mda.explorer.plugin.MdaExplorer;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDataModel;
import com.modeliosoft.modelio.mda.explorer.wizards.stereotype.StereotypeCreationDialog;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class StereotypeValidator
implements ModifyListener {
    private StereotypeCreationDialog dialog = null;
    private StereotypeCreationDataModel dataModel = null;
    private static final Pattern NoteTypeNameNamePattern = Pattern.compile("[\\p{L}\\p{N}\\._ ]+");

    public StereotypeValidator(StereotypeCreationDialog dialog, StereotypeCreationDataModel dataModel) {
        this.dialog = dialog;
        this.dataModel = dataModel;
    }

    public void modifyText(ModifyEvent e) {
        String stereotypeName = this.dialog.stereotypeNameText.getText();
        String stereotypeBaseClassName = this.dialog.metaclassCombo.getText();
        try {
            MetaModelExpert.getMetaclass((String)stereotypeBaseClassName);
            this.dialog.invalidateMetaclassNameText(false);
            if (stereotypeName != null && !stereotypeName.equals("") && this.validateStereotypeName(stereotypeName) && !this.stereotypeNameExists(stereotypeBaseClassName, stereotypeName)) {
                this.dialog.invalidateStereotypeNameText(false);
                this.dialog.createButton.setEnabled(true);
            } else {
                this.dialog.invalidateStereotypeNameText(true);
                this.dialog.createButton.setEnabled(false);
            }
        }
        catch (IllegalArgumentException iae) {
            this.dialog.invalidateMetaclassNameText(true);
            this.dialog.createButton.setEnabled(false);
        }
        this.dataModel.setStereotypeName(stereotypeName);
        this.dataModel.setMetaclassName(stereotypeBaseClassName);
    }

    private boolean stereotypeNameExists(String stereotypeMetaclass, String stereotypeName) {
        IModelingSession modelingSession = MdaExplorer.getInstance().getModelingSession();
        IProject project = modelingSession.getModel().getProject();
        try {
            Class metaclass = MetaModelExpert.getMetaclass((String)stereotypeMetaclass);
            IStereotype stereotype = project.getStereotype(metaclass, stereotypeName);
            return !stereotype.equals((Object)this.dataModel.getEditedStereotype());
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        catch (StereotypeNotFoundException e) {
            return false;
        }
    }

    protected boolean validateStereotypeName(String name) {
        return NoteTypeNameNamePattern.matcher(name).matches();
    }
}

