/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.diagram.editor.AbstractDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.DiagramCommandStack;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorContextMenuProvider;
import com.modeliosoft.modelio.diagram.editor.DiagramEditorInput;
import com.modeliosoft.modelio.diagram.editor.FlyoutPaletteComposite2;
import com.modeliosoft.modelio.diagram.editor.GraphicalEditorWithFlyoutPalette2;
import com.modeliosoft.modelio.diagram.editor.IDiagramEditor;
import com.modeliosoft.modelio.diagram.editor.IEditPartAbstractFactory;
import com.modeliosoft.modelio.diagram.editor.ModelElementDropTargetListener;
import com.modeliosoft.modelio.diagram.editor.ScalableFreeformRootEditPart2;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.editor.tools.PanSelectionTool;
import com.modeliosoft.modelio.diagram.editor.tools.PickingSelectionTool;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.OrthogonalRouter;
import com.modeliosoft.modelio.diagram.elements.core.link.ConnectionRouterRegistry;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.ui.menu.contextual.ContextMenuModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractDiagramEditor
extends GraphicalEditorWithFlyoutPalette2
implements IModelChangeListener,
IEditPartAbstractFactory,
IPickingProvider,
IDiagramEditor {
    private final RootEditPart rootEditPart = new ScalableFreeformRootEditPart2();
    private PaletteRoot paletteRoot;
    private static final double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.25, 2.5, 2.75, 3.0, 3.25, 3.5, 3.75, 4.0};

    public AbstractDiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getModelingSession().getModel().addModelListener((IModelChangeListener)this);
        this.getModelingSession().getModel().addStatusListener((IStatusChangeListener)this);
        O.getDefault().getPickingProviderService().addPickingProvider((IPickingProvider)this);
    }

    public void dispose() {
        O.getDefault().getPickingProviderService().removePickingProvider((IPickingProvider)this);
        this.getModelingSession().getModel().removeStatusListener((IStatusChangeListener)this);
        this.getModelingSession().getModel().removeModelListener((IModelChangeListener)this);
        DiagramEditorInput input = (DiagramEditorInput)this.getEditorInput();
        if (input != null) {
            input.dispose();
        }
        this.getEditDomain().getPaletteViewer().setContents(null);
        this.paletteRoot = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart2)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return new OutlinePage(this);
        }
        return super.getAdapter(type);
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        IModelChangeEvent changeEvent = event;
        AbstractDiagramEditor diagramEditor = this;
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setRootEditPart(this.rootEditPart);
        viewer.setEditPartFactory(this.getEditPartFactory());
        DefaultEditDomain editDomain = this.getEditDomain();
        PanSelectionTool selectionTool = new PanSelectionTool();
        editDomain.setActiveTool((Tool)selectionTool);
        editDomain.setDefaultTool((Tool)selectionTool);
        viewer.setEditDomain((EditDomain)editDomain);
        GmAbstractDiagram gmDiagram = ((DiagramEditorInput)this.getEditorInput()).getGmDiagram();
        IModelingSession modelingSession = DiagramEditor.getInstance().getModelingSession();
        this.getEditDomain().setCommandStack((CommandStack)new DiagramCommandStack(modelingSession, gmDiagram));
        viewer.addDropTargetListener((TransferDropTargetListener)new ModelElementDropTargetListener((EditPartViewer)viewer));
        ZoomManager zoomManager = ((ScalableFreeformRootEditPart2)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        zoomManager.setZoomLevels(zoomLevels);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setContextMenu((MenuManager)new DiagramEditorContextMenuProvider(viewer, this));
    }

    protected final IModelingSession getModelingSession() {
        return DiagramEditor.getInstance().getModelingSession();
    }

    protected void initializeConnectionRouters(ConnectionRouterRegistry routersRegistry) {
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.DIRECT, (Object)ConnectionRouter.NULL);
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.BENDPOINT, (Object)new BendpointConnectionRouter());
        routersRegistry.put((Object)StyleKey.ConnectionRouterId.ORTHOGONAL, (Object)new OrthogonalRouter());
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        ConnectionRouterRegistry routersRegistry = new ConnectionRouterRegistry();
        viewer.setProperty("ConnectionRouterRegistry", (Object)routersRegistry);
        this.initializeConnectionRouters(routersRegistry);
        GmAbstractDiagram gmDiagram = ((DiagramEditorInput)this.getEditorInput()).getGmDiagram();
        viewer.setContents((Object)gmDiagram);
        gmDiagram.refreshAllFromObModel();
    }

    protected FlyoutPaletteComposite2.FlyoutPreferences getPalettePreferences() {
        return new PalettePreferences(this);
    }

    protected abstract ContextMenuModel getCreateElementMenuModel();

    public void beginPicking() {
        this.getEditDomain().setActiveTool((Tool)new PickingSelectionTool());
    }

    public void endPicking() {
        this.getEditDomain().setActiveTool((Tool)new PanSelectionTool());
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    public void setPaletteRoot(PaletteRoot value) {
        this.paletteRoot = value;
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IAbstractDiagram diagram = ((DiagramEditorInput)this.getEditorInput()).getDiagram();
        if (diagram != null && diagram.isValid()) {
            this.setPartName(diagram.getName());
            this.setTitleImage(StandardImageService.getCmsStereotypedImage((IElement)diagram, null));
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void disposeHandle() {
    }

    public RootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    static /* synthetic */ SelectionSynchronizer access$0(AbstractDiagramEditor abstractDiagramEditor) {
        return abstractDiagramEditor.getSelectionSynchronizer();
    }

    static /* synthetic */ GraphicalViewer access$1(AbstractDiagramEditor abstractDiagramEditor) {
        return abstractDiagramEditor.getGraphicalViewer();
    }

    static /* synthetic */ void access$2(AbstractDiagramEditor abstractDiagramEditor, String string) {
        abstractDiagramEditor.setPartName(string);
    }

    static /* synthetic */ void access$3(AbstractDiagramEditor abstractDiagramEditor, Image image) {
        abstractDiagramEditor.setTitleImage(image);
    }
}

