/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

class BackgroundLayer
extends FreeformLayer {
    private int alpha = 255;
    private Image bgImage = null;
    private ImageDescriptor bgDescriptor = null;
    private Dimension tileSize = null;

    BackgroundLayer() {
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAlpha(this.alpha);
        super.paintFigure(graphics);
        if (this.bgImage != null) {
            if (this.tileSize == null || this.tileSize != null && this.tileSize.isEmpty()) {
                this.drawBackgroundTiles(graphics, this.bgImage, this.getBounds().getSize());
            } else {
                this.drawBackgroundTiles(graphics, this.bgImage, this.tileSize);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setImage(ImageDescriptor id) {
        if (id == null) {
            this.removeBgImage();
            return;
        }
        if (id.equals(this.bgDescriptor)) {
            return;
        }
        this.removeBgImage();
        Image newImage = id.createImage();
        if (newImage != null) {
            this.setImage(id, newImage);
        }
    }

    private void setImage(ImageDescriptor id, Image newImage) {
        this.bgDescriptor = id;
        this.bgImage = newImage;
    }

    private void removeBgImage() {
        if (this.bgImage != null) {
            this.bgImage.dispose();
            this.bgImage = null;
            this.bgDescriptor = null;
        }
    }

    protected void finalize() throws Throwable {
        this.removeBgImage();
        super.finalize();
    }

    private void drawBackgroundTiles(Graphics graphics, Image img, Dimension tileSize) {
        Rectangle r = this.getBounds();
        int x = r.x;
        int y = r.y;
        int xmax = r.x + r.width;
        int ymax = r.y + r.height;
        y = r.y;
        while (y < ymax) {
            x = r.x;
            while (x < xmax) {
                graphics.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, tileSize.width, tileSize.height);
                x += tileSize.width;
            }
            y += tileSize.height;
        }
    }

    public void setTileSize(Dimension size) {
        this.tileSize = size;
    }
}

