/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;

public class DiagramCommandStack
extends CommandStack {
    private IModelingSession session;
    private GmAbstractDiagram diagram;
    private boolean batchMode = false;

    public DiagramCommandStack(IModelingSession session, GmAbstractDiagram diagramModel) {
        this.session = session;
        this.diagram = diagramModel;
    }

    public boolean canRedo() {
        return this.session.getUndoManager().hasRedo();
    }

    public boolean canUndo() {
        return this.session.getUndoManager().hasUndo();
    }

    public void undo() {
        Command command = null;
        this.notifyListeners(command, 4);
        try {
            this.session.getUndoManager().undo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = null;
        this.notifyListeners(command, 2);
        try {
            this.session.getUndoManager().redo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public int getUndoLimit() {
        return -1;
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty() {
        return this.session.isDirty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.notifyListeners(command, 1);
        try {
            ITransactionManager transactionManager = this.session.getTransactionManager();
            ITransaction t = transactionManager.createTransaction(command.getLabel());
            try {
                try {
                    command.execute();
                    if (!this.batchMode) {
                        DiagramPersistence.saveDiagram((GmAbstractDiagram)this.diagram);
                    }
                    transactionManager.commit(t);
                    t = null;
                    this.notifyListeners();
                    return;
                }
                catch (InvalidTransactionException e) {
                    block25: {
                        t = null;
                        try {
                            DiagramPersistence.loadDiagram((GmAbstractDiagram)this.diagram);
                        }
                        catch (PersistenceException pe) {
                            DiagramEditor.LOG.error((Throwable)pe);
                            if ($assertionsDisabled) break block25;
                            throw new AssertionError((Object)"Problem persistence: failed to reload diagram!");
                        }
                    }
                    if (t == null) return;
                    try {
                        transactionManager.rollback(t);
                        return;
                    }
                    catch (Exception e2) {
                        DiagramEditor.LOG.error("Failed to rollback the transaction:");
                        DiagramEditor.LOG.error((Throwable)e2);
                    }
                    return;
                }
                catch (Exception e) {
                    DiagramEditor.LOG.error((Throwable)e);
                    if (t == null) return;
                    try {
                        transactionManager.rollback(t);
                        return;
                    }
                    catch (Exception e3) {
                        DiagramEditor.LOG.error("Failed to rollback the transaction:");
                        DiagramEditor.LOG.error((Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                if (t != null) {
                    try {
                        transactionManager.rollback(t);
                    }
                    catch (Exception e) {
                        DiagramEditor.LOG.error("Failed to rollback the transaction:");
                        DiagramEditor.LOG.error((Throwable)e);
                    }
                }
            }
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void markSaveLocation() {
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }
}

