/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkFactory;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmNodeFactory;
import com.modeliosoft.modelio.diagram.elements.core.model.ModelManager;
import com.modeliosoft.modelio.diagram.elements.core.model.StandardElementInitializer;
import com.modeliosoft.modelio.diagram.elements.gmfactory.GmLinkFactory;
import com.modeliosoft.modelio.diagram.elements.gmfactory.GmNodeFactory;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public abstract class DiagramEditorInput
implements IEditorInput {
    private IAbstractDiagram diagram;
    private GmAbstractDiagram model;

    public DiagramEditorInput(IModelingSession session, IAbstractDiagram diagram) {
        this.diagram = diagram;
        ModelManager modelManager = new ModelManager(session);
        this.model = this.createModel(modelManager, diagram);
        this.model.setGmNodeFactory(this.createGmNodeFactory(this.model));
        this.model.setGmLinkCreationFactory(this.createGmLinkFactory(this.model));
        this.model.setElementInitializer(this.createElementInitializer(session));
        try {
            DiagramPersistence.loadDiagram((GmAbstractDiagram)this.model);
        }
        catch (PersistenceException pe) {
            DiagramEditor.LOG.error((Throwable)pe);
            this.model.dispose();
            this.model.delete();
            this.model = null;
        }
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return this.diagram.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.diagram.getName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this.diagram)) {
            return this.diagram;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiagramEditorInput)) {
            return false;
        }
        DiagramEditorInput other = (DiagramEditorInput)obj;
        return !(this.diagram == null ? other.diagram != null : !this.diagram.equals((Object)other.diagram));
    }

    public IAbstractDiagram getDiagram() {
        return this.diagram;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diagram == null ? 0 : this.diagram.hashCode());
        return result;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
    }

    protected abstract GmAbstractDiagram createModel(ModelManager var1, IAbstractDiagram var2);

    protected IGmLinkFactory createGmLinkFactory(GmAbstractDiagram gmDiagram) {
        return GmLinkFactory.getInstance();
    }

    protected IGmNodeFactory createGmNodeFactory(GmAbstractDiagram gmDiagram) {
        return GmNodeFactory.getInstance();
    }

    protected IElementInitializer createElementInitializer(IModelingSession session) {
        return new StandardElementInitializer(session);
    }

    public GmAbstractDiagram getGmDiagram() {
        return this.model;
    }

    @Deprecated
    public void writeModel() {
        DiagramPersistence.saveDiagram((GmAbstractDiagram)this.model);
    }
}

