/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import com.modeliosoft.modelio.diagram.editor.FlyoutPaletteComposite2;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.XMLMemento;

public class FlyoutPaletteComposite2
extends Composite {
    private static final FontManager FONT_MGR = new FontManager(null);
    private static final String PROPERTY_PALETTE_WIDTH = "org.eclipse.gef.ui.palette.fpa.paletteWidth";
    private static final String PROPERTY_STATE = "org.eclipse.gef.ui.palette.fpa.state";
    private static final String PROPERTY_DOCK_LOCATION = "org.eclipse.gef.ui.palette.fpa.dock";
    static final int DEFAULT_PALETTE_SIZE = 125;
    private static final int MIN_PALETTE_SIZE = 20;
    private static final int MAX_PALETTE_SIZE = 500;
    private static final int STATE_HIDDEN = 8;
    private static final int STATE_EXPANDED = 1;
    private static final Dimension ARROW_SIZE = new Dimension(6, 11);
    private static final int SASH_BUTTON_WIDTH = 11;
    public static final int STATE_COLLAPSED = 2;
    public static final int STATE_PINNED_OPEN = 4;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Composite paletteContainer;
    private PaletteViewer pViewer;
    private PaletteViewer externalViewer;
    private IMemento capturedPaletteState;
    private Control graphicalControl;
    private Composite sash;
    private PaletteViewerProvider provider;
    private FlyoutPreferences prefs;
    private Point cachedBounds = new Point(0, 0);
    private boolean transferFocus = false;
    private int dock = 16;
    private int paletteState = 8;
    private int paletteWidth = 125;
    private int minWidth = 20;
    private int cachedSize = -1;
    private int cachedState = -1;
    private int cachedLocation = -1;
    private int cachedTitleHeight = 24;
    private IPerspectiveListener perspectiveListener = new /* Unavailable Anonymous Inner Class!! */;

    public FlyoutPaletteComposite2(Composite parent, int style, IWorkbenchPage page, PaletteViewerProvider pvProvider, FlyoutPreferences flyoutPreferences) {
        super(parent, style & 0x800);
        this.provider = pvProvider;
        this.prefs = flyoutPreferences;
        this.sash = this.createSash();
        this.paletteContainer = this.createPaletteContainer();
        this.hookIntoWorkbench(page.getWorkbenchWindow());
        if (this.prefs.getPaletteWidth() <= 0) {
            this.prefs.setPaletteWidth(125);
        }
        this.setPaletteWidth(this.prefs.getPaletteWidth());
        this.setDockLocation(this.prefs.getDockLocation());
        this.updateState(page);
        this.addListener(11, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.listeners.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addListenerToCtrlHierarchy(Control parent, int eventType, Listener listener) {
        parent.addListener(eventType, listener);
        if (!(parent instanceof Composite)) {
            return;
        }
        Control[] children = ((Composite)parent).getChildren();
        int i = 0;
        while (i < children.length) {
            this.addListenerToCtrlHierarchy(children[i], eventType, listener);
            ++i;
        }
    }

    private IMemento capturePaletteState(PaletteViewer viewer) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"paletteState");
        try {
            viewer.saveState((IMemento)memento);
        }
        catch (RuntimeException re) {
            memento = null;
        }
        return memento;
    }

    private Control createFlyoutControlButton(Composite parent) {
        return new ButtonCanvas(this, parent);
    }

    private Composite createPaletteContainer() {
        return new PaletteComposite(this, (Composite)this, 0);
    }

    private Composite createSash() {
        return new Sash(this, (Composite)this, 0);
    }

    private Control createTitle(Composite parent, boolean isHorizontal) {
        return new TitleCanvas(this, parent, isHorizontal);
    }

    private Control getPaletteViewerControl() {
        Control result = null;
        if (this.pViewer != null) {
            result = this.pViewer.getControl();
        }
        if (result != null && !result.isDisposed() && result.getParent() != this.paletteContainer) {
            result = result.getParent();
        }
        return result;
    }

    private void handlePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.updateState(page);
    }

    private void handlePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("viewShow") || changeId.equals("viewHide")) {
            this.updateState(page);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isDescendantOf(Control ancestor, Control descendant) {
        if (ancestor != null && descendant != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (ancestor == descendant) {
                return true;
            }
            descendant = descendant.getParent();
lbl6:
            // 2 sources

            ** while (descendant != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    private boolean isInState(int state) {
        return (this.paletteState & state) != 0;
    }

    private boolean isMirrored() {
        return (this.getStyle() & 0x8000000) != 0;
    }

    public void layout(boolean changed) {
        if (this.graphicalControl == null || this.graphicalControl.isDisposed()) {
            return;
        }
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        int sashWidth = this.sash.computeSize((int)-1, (int)-1).x;
        int pWidth = this.paletteWidth;
        int maxWidth = Math.min(area.width / 2, 500);
        maxWidth = Math.max(maxWidth, this.minWidth);
        pWidth = Math.max(pWidth, this.minWidth);
        pWidth = Math.min(pWidth, maxWidth);
        if (this.paletteState == this.cachedState && pWidth == this.cachedSize && this.cachedLocation == this.dock && this.cachedBounds == this.getSize()) {
            return;
        }
        this.cachedState = this.paletteState;
        this.cachedSize = pWidth;
        this.cachedLocation = this.dock;
        this.cachedBounds = this.getSize();
        this.setRedraw(false);
        if (this.isInState(8)) {
            this.sash.setVisible(false);
            this.paletteContainer.setVisible(false);
            this.graphicalControl.setBounds(area);
        } else if (this.dock == 16) {
            this.layoutComponentsEast(area, sashWidth, pWidth);
        } else {
            this.layoutComponentsWest(area, sashWidth, pWidth);
        }
        this.sash.layout();
        this.setRedraw(true);
        this.update();
    }

    private void layoutComponentsEast(Rectangle area, int sashWidth, int pWidth) {
        if (this.isInState(2)) {
            this.paletteContainer.setVisible(false);
            this.sash.setBounds(area.x + area.width - sashWidth, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth, area.height);
            this.sash.setVisible(true);
        } else if (this.isInState(1)) {
            this.paletteContainer.moveAbove(this.graphicalControl);
            this.sash.moveAbove((Control)this.paletteContainer);
            this.paletteContainer.setBounds(area.x + area.width - pWidth, area.y, pWidth, area.height);
            this.sash.setBounds(area.x + area.width - pWidth - sashWidth, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth, area.height);
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
        } else if (this.isInState(4)) {
            this.paletteContainer.setBounds(area.x + area.width - pWidth, area.y, pWidth, area.height);
            this.sash.setBounds(area.x + area.width - pWidth - sashWidth, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x, area.y, area.width - sashWidth - pWidth, area.height);
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
        }
    }

    private void layoutComponentsWest(Rectangle area, int sashWidth, int pWidth) {
        if (this.isInState(2)) {
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(false);
            this.sash.setBounds(area.x, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x + sashWidth, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(1)) {
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
            this.paletteContainer.moveAbove(this.graphicalControl);
            this.sash.moveAbove((Control)this.paletteContainer);
            this.paletteContainer.setBounds(area.x, area.y, pWidth, area.height);
            this.sash.setBounds(area.x + pWidth, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x + sashWidth, area.y, area.width - sashWidth, area.height);
        } else if (this.isInState(4)) {
            this.sash.setVisible(true);
            this.paletteContainer.setVisible(true);
            this.paletteContainer.setBounds(area.x, area.y, pWidth, area.height);
            this.sash.setBounds(area.x + pWidth, area.y, sashWidth, area.height);
            this.graphicalControl.setBounds(area.x + pWidth + sashWidth, area.y, area.width - sashWidth - pWidth, area.height);
        }
    }

    private void hookIntoWorkbench(IWorkbenchWindow window) {
        window.addPerspectiveListener(this.perspectiveListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean restorePaletteState(PaletteViewer newPalette, IMemento state) {
        if (state != null) {
            try {
                return newPalette.restoreState(state);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setExternalViewer(PaletteViewer viewer) {
        if (viewer == null && this.externalViewer != null) {
            this.capturedPaletteState = this.capturePaletteState(this.externalViewer);
        }
        this.externalViewer = viewer;
        if (this.externalViewer != null && this.pViewer != null) {
            this.transferState(this.pViewer, this.externalViewer);
        }
    }

    private void setDockLocation(int position) {
        if (position != 16 && position != 8) {
            return;
        }
        if (position != this.dock) {
            int oldPosition = this.dock;
            this.dock = position;
            this.listeners.firePropertyChange(PROPERTY_DOCK_LOCATION, oldPosition, this.dock);
            if (this.pViewer != null) {
                this.layout(true);
            }
        }
    }

    private void setPaletteWidth(int newSize) {
        if (this.paletteWidth != newSize) {
            int oldValue = this.paletteWidth;
            this.paletteWidth = newSize;
            this.listeners.firePropertyChange(PROPERTY_PALETTE_WIDTH, oldValue, this.paletteWidth);
            if (this.pViewer != null) {
                this.layout(true);
            }
        }
    }

    public void setGraphicalControl(Control graphicalViewer) {
        Assert.isTrue((graphicalViewer != null ? 1 : 0) != 0);
        if (graphicalViewer != null) {
            Assert.isTrue((graphicalViewer.getParent() == this ? 1 : 0) != 0);
            Assert.isTrue((this.graphicalControl == null ? 1 : 0) != 0);
            this.graphicalControl = graphicalViewer;
            this.addListenerToCtrlHierarchy(this.graphicalControl, 6, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void hookDropTargetListener(GraphicalViewer viewer) {
        viewer.addDropTargetListener((TransferDropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setState(int newState) {
        if (newState != 8 && newState != 4 && newState != 1) {
            newState = 2;
        }
        if (this.paletteState == newState) {
            return;
        }
        int oldState = this.paletteState;
        this.paletteState = newState;
        switch (this.paletteState) {
            case 1: 
            case 2: 
            case 4: {
                if (this.pViewer != null) break;
                this.pViewer = this.provider.createPaletteViewer(this.paletteContainer);
                if (this.externalViewer != null) {
                    this.transferState(this.externalViewer, this.pViewer);
                } else {
                    this.restorePaletteState(this.pViewer, this.capturedPaletteState);
                }
                this.capturedPaletteState = null;
                this.minWidth = Math.max(this.pViewer.getControl().computeSize((int)0, (int)0).x, 20);
                break;
            }
            case 8: {
                Control pViewerCtrl;
                if (this.pViewer == null) break;
                if (this.externalViewer != null) {
                    this.provider.getEditDomain().setPaletteViewer(this.externalViewer);
                    this.transferState(this.pViewer, this.externalViewer);
                }
                if (this.provider.getEditDomain().getPaletteViewer() == this.pViewer) {
                    this.provider.getEditDomain().setPaletteViewer(null);
                }
                if ((pViewerCtrl = this.getPaletteViewerControl()) != null && !pViewerCtrl.isDisposed()) {
                    pViewerCtrl.dispose();
                }
                this.pViewer = null;
            }
        }
        if (this.paletteState == 2 && this.pViewer.getControl().isFocusControl()) {
            this.graphicalControl.setFocus();
        }
        this.layout(true);
        this.listeners.firePropertyChange(PROPERTY_STATE, oldState, newState);
    }

    private void transferState(PaletteViewer src, PaletteViewer dest) {
        this.restorePaletteState(dest, this.capturePaletteState(src));
    }

    private void updateState(IWorkbenchPage page) {
        IViewReference view = page.findViewReference("org.eclipse.gef.ui.palette_view");
        if (view == null && this.isInState(8)) {
            this.setState(this.prefs.getPaletteState());
        }
        if (view != null && !this.isInState(8)) {
            this.setState(8);
        }
    }

    static /* synthetic */ void access$0(FlyoutPaletteComposite2 flyoutPaletteComposite2, IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
        flyoutPaletteComposite2.handlePerspectiveActivated(iWorkbenchPage, iPerspectiveDescriptor);
    }

    static /* synthetic */ void access$1(FlyoutPaletteComposite2 flyoutPaletteComposite2, IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
        flyoutPaletteComposite2.handlePerspectiveChanged(iWorkbenchPage, iPerspectiveDescriptor, string);
    }

    static /* synthetic */ boolean access$2(FlyoutPaletteComposite2 flyoutPaletteComposite2, int n) {
        return flyoutPaletteComposite2.isInState(n);
    }

    static /* synthetic */ void access$3(FlyoutPaletteComposite2 flyoutPaletteComposite2, int n) {
        flyoutPaletteComposite2.setState(n);
    }

    static /* synthetic */ Control access$4(FlyoutPaletteComposite2 flyoutPaletteComposite2, Composite composite) {
        return flyoutPaletteComposite2.createFlyoutControlButton(composite);
    }

    static /* synthetic */ PropertyChangeSupport access$5(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.listeners;
    }

    static /* synthetic */ int access$6(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.cachedTitleHeight;
    }

    static /* synthetic */ Composite access$7(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.paletteContainer;
    }

    static /* synthetic */ int access$8(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.dock;
    }

    static /* synthetic */ void access$9(FlyoutPaletteComposite2 flyoutPaletteComposite2, int n) {
        flyoutPaletteComposite2.setPaletteWidth(n);
    }

    static /* synthetic */ boolean access$10(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.transferFocus;
    }

    static /* synthetic */ void access$11(FlyoutPaletteComposite2 flyoutPaletteComposite2, boolean bl) {
        flyoutPaletteComposite2.transferFocus = bl;
    }

    static /* synthetic */ Composite access$12(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.sash;
    }

    static /* synthetic */ Control access$13(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.graphicalControl;
    }

    static /* synthetic */ boolean access$14(FlyoutPaletteComposite2 flyoutPaletteComposite2, Control control, Control control2) {
        return flyoutPaletteComposite2.isDescendantOf(control, control2);
    }

    static /* synthetic */ boolean access$15(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.isMirrored();
    }

    static /* synthetic */ void access$16(FlyoutPaletteComposite2 flyoutPaletteComposite2, int n) {
        flyoutPaletteComposite2.setDockLocation(n);
    }

    static /* synthetic */ Control access$17(FlyoutPaletteComposite2 flyoutPaletteComposite2, Composite composite, boolean bl) {
        return flyoutPaletteComposite2.createTitle(composite, bl);
    }

    static /* synthetic */ Control access$18(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.getPaletteViewerControl();
    }

    static /* synthetic */ void access$19(FlyoutPaletteComposite2 flyoutPaletteComposite2, int n) {
        flyoutPaletteComposite2.cachedTitleHeight = n;
    }

    static /* synthetic */ Dimension access$20() {
        return ARROW_SIZE;
    }

    static /* synthetic */ FontManager access$21() {
        return FONT_MGR;
    }

    static /* synthetic */ int access$22(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.minWidth;
    }

    static /* synthetic */ FlyoutPreferences access$23(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.prefs;
    }

    static /* synthetic */ int access$24(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.paletteWidth;
    }

    static /* synthetic */ int access$25(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.paletteState;
    }

    static /* synthetic */ IPerspectiveListener access$26(FlyoutPaletteComposite2 flyoutPaletteComposite2) {
        return flyoutPaletteComposite2.perspectiveListener;
    }

    static /* synthetic */ void access$27(FlyoutPaletteComposite2 flyoutPaletteComposite2, IPerspectiveListener iPerspectiveListener) {
        flyoutPaletteComposite2.perspectiveListener = iPerspectiveListener;
    }
}

