/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor;

import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagramStyleKeys;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.events.KeyEvent;

public class MoveKeyHandler
extends KeyHandler {
    private final GraphicalViewer viewer;
    private boolean moveDone = false;

    public MoveKeyHandler(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public boolean keyPressed(KeyEvent event) {
        List selectedEditParts = this.viewer.getSelectedEditParts();
        if (!selectedEditParts.isEmpty()) {
            EditPart contents = this.viewer.getContents();
            SnapToHelper snapToHelper = (SnapToHelper)contents.getAdapter(SnapToHelper.class);
            int offset = 11;
            if (contents.getModel() instanceof IGmObject) {
                offset = ((IGmObject)contents.getModel()).getStyle().getInteger(GmAbstractDiagramStyleKeys.GRIDSPACING);
                offset = offset / 2 + 1;
            }
            if ((event.stateMask & 0x10000) != 0) {
                offset = 10;
            }
            if ((event.stateMask & 0x40000) != 0) {
                offset = 1;
            }
            Point moveDelta = new Point(0, 0);
            switch (event.keyCode) {
                case 0x1000001: {
                    moveDelta.setLocation(0, -offset);
                    break;
                }
                case 0x1000003: {
                    moveDelta.setLocation(-offset, 0);
                    break;
                }
                case 0x1000002: {
                    moveDelta.setLocation(0, offset);
                    break;
                }
                case 0x1000004: {
                    moveDelta.setLocation(offset, 0);
                }
            }
            if (!moveDelta.equals(0, 0)) {
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
                request.setLocation(((GraphicalEditPart)this.viewer.getFocusEditPart()).getFigure().getBounds().getCenter());
                request.setMoveDelta(moveDelta);
                if (snapToHelper != null && (event.stateMask & 0x10000) == 0 && (event.stateMask & 0x40000) == 0) {
                    this.snap(request, selectedEditParts, snapToHelper);
                }
                for (Object o : selectedEditParts) {
                    GraphicalEditPart editPart = (GraphicalEditPart)o;
                    Command command = editPart.getCommand((Request)request);
                    if (command == null || !command.canExecute()) continue;
                    command.execute();
                    this.moveDone = true;
                }
            }
        }
        return super.keyPressed(event);
    }

    private void snap(ChangeBoundsRequest request, List<?> selectedEditParts, SnapToHelper snapToHelper) {
        PrecisionRectangle compoundRectangle = null;
        PrecisionRectangle sourceRectangle = null;
        for (Object o : selectedEditParts) {
            GraphicalEditPart editPart = (GraphicalEditPart)o;
            IFigure figure = editPart.getFigure();
            PrecisionRectangle bounds = null;
            bounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)bounds);
            compoundRectangle = compoundRectangle == null ? new PrecisionRectangle((Rectangle)bounds) : compoundRectangle.union(bounds);
            if (editPart.getSelected() != 2) continue;
            sourceRectangle = bounds;
        }
        if (compoundRectangle != null && sourceRectangle != null) {
            compoundRectangle.translate(request.getMoveDelta());
            sourceRectangle.translate(request.getMoveDelta());
            PrecisionPoint preciseDelta = new PrecisionPoint(request.getMoveDelta());
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{sourceRectangle, compoundRectangle}, preciseDelta);
            request.setMoveDelta((Point)preciseDelta);
        }
    }

    public boolean keyReleased(KeyEvent event) {
        if (this.moveDone) {
            this.viewer.getEditDomain().getCommandStack().execute((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.moveDone = false;
        }
        return super.keyReleased(event);
    }
}

