/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.createpopup.contribs;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.editor.createpopup.contribs.CreationContributionItem;
import com.modeliosoft.modelio.ui.menu.contextual.CommandModel;
import com.modeliosoft.modelio.ui.menu.contextual.ContextMenuModel;
import com.modeliosoft.modelio.ui.menu.contextual.ItemModel;
import com.modeliosoft.modelio.ui.menu.contextual.MenuModel;
import com.modeliosoft.modelio.ui.menu.contextual.SeparatorModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class MenuDynamicContribution
extends CompoundContributionItem {
    private static Map<String, ContextMenuModel> menuModels = new HashMap();

    public static Object getMenuModel(String popupMenuId) {
        return menuModels.get(popupMenuId);
    }

    public static void registerMenuModel(String popupMenuId, ContextMenuModel model) {
        menuModels.put(popupMenuId, model);
    }

    public MenuDynamicContribution(String id) {
        super(id);
    }

    public MenuDynamicContribution() {
    }

    protected IContributionItem[] getContributionItems() {
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() != 1) {
            return new IContributionItem[0];
        }
        ContextMenuModel contextMenuModel = (ContextMenuModel)menuModels.get(this.getId());
        if (contextMenuModel == null) {
            return new IContributionItem[0];
        }
        IElement selectedElement = (IElement)selectedElements.get(0);
        if (selectedElement instanceof IAbstractDiagram && (selectedElement = ((IAbstractDiagram)selectedElement).getOrigin()) == null) {
            return new IContributionItem[0];
        }
        List itemModels = contextMenuModel.getItems(selectedElement.getMetaclassName(), null);
        IWorkbenchWindow serviceLocator = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        ArrayList<IContributionItem> list = new ArrayList<IContributionItem>();
        for (ItemModel itemModel : itemModels) {
            list.add(this.makeContributionItem(itemModel, commandService, handlerService));
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                IElement element;
                if (!(selectedObject instanceof IAdaptable) || (element = (IElement)((IAdaptable)selectedObject).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }

    private IContributionItem makeContributionItem(ItemModel itemModel, ICommandService commandService, IHandlerService handlerService) {
        if (itemModel instanceof CommandModel) {
            return CreationContributionItem.create((CommandModel)((CommandModel)itemModel));
        }
        if (itemModel instanceof MenuModel) {
            MenuModel menuModel = (MenuModel)itemModel;
            MenuManager menuManager = new MenuManager(menuModel.getLabel(), menuModel.getImage(), menuModel.getId());
            for (ItemModel subItemModel : menuModel.getItems()) {
                IContributionItem contribItem = this.makeContributionItem(subItemModel, commandService, handlerService);
                if (contribItem == null) continue;
                menuManager.add(contribItem);
            }
            return menuManager;
        }
        if (itemModel instanceof SeparatorModel) {
            SeparatorModel separatorModel = (SeparatorModel)itemModel;
            String separatorId = separatorModel.getId();
            if (separatorId == null || separatorId.equals("")) {
                return new Separator();
            }
            return new Separator(separatorId);
        }
        return null;
    }
}

