/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers;

import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class AutoSizeHandler
extends AbstractHandler {
    protected void execute(GraphicalEditPart primarySelection, List<GraphicalEditPart> otherSelections) {
        CompoundCommand compound = new CompoundCommand("Auto size");
        EditPartViewer viewer = null;
        if (primarySelection != null) {
            ChangeBoundsRequest req = this.buildAutoSizeRequest(primarySelection);
            if (req != null) {
                compound.add(primarySelection.getCommand((Request)req));
            }
            viewer = primarySelection.getViewer();
        }
        for (GraphicalEditPart editPart : otherSelections) {
            ChangeBoundsRequest req = this.buildAutoSizeRequest(editPart);
            if (req != null) {
                compound.add(editPart.getCommand((Request)req));
            }
            if (viewer != null) continue;
            viewer = editPart.getViewer();
        }
        if (viewer != null && compound.canExecute()) {
            viewer.getEditDomain().getCommandStack().execute((Command)compound);
        } else if (viewer == null) {
            DiagramEditor.LOG.warning("AutosizeHandler#align : could not reach a valid EditPartViewer");
        }
    }

    private ChangeBoundsRequest buildAutoSizeRequest(GraphicalEditPart editPart) {
        Dimension newSize;
        if (editPart instanceof AbstractDiagramEditPart) {
            return null;
        }
        IFigure fig = editPart.getFigure();
        Dimension oldSize = this.getEffectiveBounds(fig).getSize();
        if (oldSize.equals((Object)(newSize = this.getMinimumSize(editPart)))) {
            return null;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setEditParts((EditPart)editPart);
        req.setSizeDelta(newSize.getCopy().getShrinked(oldSize));
        req.setMoveDelta(new Point(0, 0));
        return req;
    }

    private Dimension getMinimumSize(GraphicalEditPart editPart) {
        GraphicalEditPart mainNodeEditPart;
        GmPortContainer gpc;
        GmNodeModel mainNode;
        if (editPart.getModel() instanceof GmPortContainer && (mainNode = (gpc = (GmPortContainer)editPart.getModel()).getMainNode()) != null && (mainNodeEditPart = (GraphicalEditPart)editPart.getViewer().getEditPartRegistry().get(mainNode)) != null) {
            IFigure mainFig = mainNodeEditPart.getFigure();
            return mainFig.getMinimumSize();
        }
        return editPart.getFigure().getMinimumSize();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GraphicalEditPart primarySelection = null;
        ArrayList<GraphicalEditPart> otherSelections = new ArrayList<GraphicalEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                if (!(selectedObject instanceof GraphicalEditPart)) continue;
                GraphicalEditPart editPart = (GraphicalEditPart)selectedObject;
                boolean isPrimary = editPart.getSelected() == 2;
                while (((GmModel)editPart.getModel()).getRepresentedIElement() == null) {
                    editPart = (GraphicalEditPart)editPart.getParent();
                }
                if (isPrimary) {
                    primarySelection = editPart;
                    otherSelections.remove(editPart);
                    continue;
                }
                if (editPart == primarySelection || otherSelections.contains(editPart)) continue;
                otherSelections.add(editPart);
            }
        }
        this.filterSelection(primarySelection, otherSelections);
        this.execute(primarySelection, otherSelections);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void filterSelection(GraphicalEditPart primarySelection, List<GraphicalEditPart> otherSelections) {
        ArrayList<GraphicalEditPart> otherSelectionsCopy = new ArrayList<GraphicalEditPart>(otherSelections);
        otherSelectionsCopy.add(primarySelection);
        for (EditPart editPart : otherSelectionsCopy) {
            void var4_5;
            boolean ancestorFound = false;
            while (var4_5 != null && !ancestorFound) {
                if (otherSelectionsCopy.contains(var4_5.getParent())) {
                    otherSelections.remove(var4_5);
                    ancestorFound = true;
                }
                EditPart editPart2 = var4_5.getParent();
            }
        }
    }

    protected Rectangle getEffectiveBounds(IFigure figure) {
        return figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds().getCopy() : figure.getBounds().getCopy();
    }
}

