/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class ChangeLinkRouterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String routerId = event.getParameter("routerId");
        List selectedLinks = this.getLinksToProcess();
        IModelingSession modellingSession = DiagramEditor.getInstance().getModelingSession();
        ITransactionManager transactionManager = modellingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Set router " + routerId);
        try {
            try {
                for (GmLinkEditPart linkEditpart : selectedLinks) {
                    StyleKey.ConnectionRouterId routerKind = StyleKey.ConnectionRouterId.valueOf((String)routerId);
                    GmLink link = (GmLink)linkEditpart.getModel();
                    StyleKey styleKey = link.getStyleKey(MetaKey.CONNECTIONROUTER);
                    if (styleKey == null) continue;
                    link.getStyle().setProperty(styleKey, (Object)routerKind);
                }
            }
            catch (InvalidTransactionException exception) {
                transaction = null;
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        return null;
    }

    protected List<GmLinkEditPart> getLinksToProcess() {
        ArrayList<GmLinkEditPart> selectedLinks = new ArrayList<GmLinkEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                if (!(selectedObject instanceof GmLinkEditPart)) continue;
                selectedLinks.add((GmLinkEditPart)selectedObject);
            }
        }
        return selectedLinks;
    }

    public boolean isEnabled() {
        List selectedLinks = this.getLinksToProcess();
        if (selectedLinks.isEmpty()) {
            return false;
        }
        for (GmLinkEditPart linkEditpart : selectedLinks) {
            GmLink link = (GmLink)linkEditpart.getModel();
            StyleKey styleKey = link.getStyleKey(MetaKey.CONNECTIONROUTER);
            if (styleKey == null) continue;
            return true;
        }
        return false;
    }
}

