/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.elements.core.commands.DeleteInModelCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class DeleteInModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<GraphicalEditPart> selected = new ArrayList<GraphicalEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                if (!(selectedObject instanceof GraphicalEditPart)) continue;
                selected.add((GraphicalEditPart)selectedObject);
            }
        }
        this.deleteRepresentedElements(selected);
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    void deleteRepresentedElements(List<GraphicalEditPart> selected) {
        if (selected.isEmpty()) {
            return;
        }
        CompoundCommand compound = new CompoundCommand("Delete");
        ArrayList<GraphicalEditPart> toMask = new ArrayList<GraphicalEditPart>();
        ArrayList<IElement> toDelete = new ArrayList<IElement>();
        for (GraphicalEditPart editPart : selected) {
            Object model = editPart.getModel();
            if (!(model instanceof GmModel)) continue;
            GmModel gmModel = (GmModel)model;
            IElement el = gmModel.getRelatedIElement();
            if (el == null) {
                toMask.add(editPart);
            }
            if (el == null || toDelete.contains(el)) continue;
            toDelete.add(el);
        }
        if (!toDelete.isEmpty()) {
            DeleteInModelCommand cmd = new DeleteInModelCommand();
            for (IElement iElement : toDelete) {
                cmd.addElementToDelete(iElement);
            }
            if (cmd.canExecute()) {
                compound.add((Command)cmd);
            }
        }
        if (!toMask.isEmpty()) {
            GroupRequest deleteReq = new GroupRequest((Object)"delete");
            deleteReq.setEditParts(toMask);
            for (EditPart editPart : toMask) {
                Command cmd2 = editPart.getCommand((Request)deleteReq);
                if (cmd2 == null) continue;
                compound.add(cmd2);
            }
        }
        if (compound.canExecute()) {
            EditDomain editDomain = selected.get(0).getViewer().getEditDomain();
            editDomain.getCommandStack().execute((Command)compound);
        }
    }
}

