/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers;

import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramFigure;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageBuilder {
    private static final int MARGIN = 10;

    public Image makeImage(RootEditPart rootEditPart, int format, int margin) {
        LayerManager lm = (LayerManager)rootEditPart;
        IFigure backgroundLayer = lm.getLayer((Object)"BACKGROUND_LAYER");
        Layer printableLayers = (Layer)lm.getLayer((Object)"Printable Layers");
        ConnectionLayer connectionLayer = (ConnectionLayer)lm.getLayer((Object)"Connection Layer");
        printableLayers.add(backgroundLayer, 0);
        Rectangle contentsBounds = this.computeContentsBounds(printableLayers, connectionLayer);
        Image img = new Image((Device)Display.getDefault(), contentsBounds.width + 2 * margin, contentsBounds.height + 2 * margin);
        GC imageGC = new GC((Drawable)img);
        int deltaX = margin + -contentsBounds.x;
        int deltaY = margin + -contentsBounds.y;
        SWTGraphics graphics = new SWTGraphics(imageGC);
        graphics.translate(deltaX, deltaY);
        graphics.setClip(contentsBounds);
        printableLayers.paint((Graphics)graphics);
        graphics.dispose();
        imageGC.dispose();
        printableLayers.remove(backgroundLayer);
        Layer scalableLayers = (Layer)lm.getLayer((Object)"Scalable Layers");
        scalableLayers.add(backgroundLayer, (Object)"BACKGROUND_LAYER", 0);
        return img;
    }

    private AbstractDiagramFigure getDiagramFigure(Layer layer) {
        AbstractDiagramFigure result = null;
        for (Object o : layer.getChildren()) {
            AbstractDiagramFigure fig;
            if (o instanceof AbstractDiagramFigure) {
                return (AbstractDiagramFigure)o;
            }
            if (!(o instanceof Layer) || (fig = this.getDiagramFigure((Layer)o)) == null) continue;
            result = fig;
        }
        return result;
    }

    private Rectangle computeContentsBounds(Layer printableLayers, ConnectionLayer connectionLayer) {
        Rectangle results = null;
        AbstractDiagramFigure diagramFigure = this.getDiagramFigure(printableLayers);
        assert (diagramFigure != null);
        results = this.computeMinimumBounds(diagramFigure);
        results.union(this.computeMinimumBounds(connectionLayer));
        return results;
    }

    private Rectangle computeMinimumBounds(ConnectionLayer connectionLayer) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object o : connectionLayer.getChildren()) {
            Rectangle b = ((Figure)o).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    private Rectangle computeMinimumBounds(AbstractDiagramFigure figure) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object fig : figure.getChildren()) {
            Rectangle b = ((Figure)fig).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Image makeImage(RootEditPart rootEditPart, int format) {
        return this.makeImage(rootEditPart, format, 10);
    }

    public Image makeViewerImage(RootEditPart rootEditPart) {
        LayerManager lm = (LayerManager)rootEditPart;
        IFigure backgroundLayer = lm.getLayer((Object)"BACKGROUND_LAYER");
        Layer printableLayers = (Layer)lm.getLayer((Object)"Printable Layers");
        ConnectionLayer connectionLayer = (ConnectionLayer)lm.getLayer((Object)"Connection Layer");
        printableLayers.add(backgroundLayer, 0);
        IFigure rootFigure = ((LayerManager)rootEditPart).getLayer((Object)"Printable Layers");
        Rectangle rootFigureBounds = rootFigure.getBounds();
        Image img = new Image((Device)Display.getDefault(), rootFigureBounds.width + 20, rootFigureBounds.height + 20);
        GC imageGC = new GC((Drawable)img);
        int deltaX = 10 + -rootFigureBounds.x;
        int deltaY = 10 + -rootFigureBounds.y;
        SWTGraphics graphics = new SWTGraphics(imageGC);
        graphics.translate(deltaX, deltaY);
        graphics.setClip(rootFigureBounds);
        printableLayers.paint((Graphics)graphics);
        graphics.dispose();
        imageGC.dispose();
        printableLayers.remove(backgroundLayer);
        Layer scalableLayers = (Layer)lm.getLayer((Object)"Scalable Layers");
        scalableLayers.add(backgroundLayer, (Object)"BACKGROUND_LAYER", 0);
        return img;
    }
}

