/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.print;

import com.modeliosoft.modelio.diagram.editor.handlers.ImageBuilder;
import com.modeliosoft.modelio.diagram.editor.handlers.print.PrintMargin;
import com.modeliosoft.modelio.diagram.editor.handlers.print.PrintPageNavigation;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PrintSetupDialog
extends Dialog {
    Shell shell;
    Canvas canvas;
    Printer printer;
    PrintMargin margin;
    Image image;
    int printMode = 2;
    Button previousButton;
    Button nextButton;
    Label pagesLabel;
    PrintPageNavigation pageNavigation;
    RootEditPart rootEditPart;

    public PrintSetupDialog(RootEditPart rootEditPart) {
        super(Display.getCurrent().getActiveShell());
        this.rootEditPart = rootEditPart;
        ImageBuilder imageBuilder = new ImageBuilder();
        this.image = imageBuilder.makeViewerImage(rootEditPart);
    }

    public void open() {
        this.shell = new Shell(Display.getCurrent().getActiveShell(), 67696);
        this.shell.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Title"));
        this.shell.setLayout((Layout)new GridLayout(5, false));
        this.canvas = new Canvas((Composite)this.shell, 2048);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 2;
        gridData.widthHint = 300;
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        Group optionsGroup = new Group((Composite)this.shell, 0);
        optionsGroup.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.PrintOptions"));
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginWidth = 5;
        optionsLayout.marginHeight = 5;
        optionsGroup.setLayout((Layout)optionsLayout);
        gridData = new GridData(768, 128, false, false);
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        optionsGroup.setLayoutData((Object)gridData);
        Button adjustCheck = new Button((Composite)optionsGroup, 32);
        adjustCheck.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.FitToPage"));
        adjustCheck.setSelection(true);
        adjustCheck.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite cButtons = new Composite((Composite)this.shell, 0);
        FillLayout orientationLayout = new FillLayout();
        orientationLayout.type = 512;
        orientationLayout.marginWidth = 5;
        orientationLayout.marginHeight = 5;
        orientationLayout.spacing = 5;
        cButtons.setLayout((Layout)orientationLayout);
        gridData = new GridData(131072, 128, false, false);
        gridData.widthHint = 100;
        gridData.verticalSpan = 3;
        cButtons.setLayoutData((Object)gridData);
        Button printButton = new Button(cButtons, 8);
        printButton.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Print"));
        printButton.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        Button closeButton = new Button(cButtons, 8);
        closeButton.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Cancel"));
        closeButton.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        Group orientationGroup = new Group((Composite)this.shell, 0);
        orientationGroup.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Orientation"));
        orientationLayout = new FillLayout();
        orientationLayout.type = 512;
        orientationLayout.marginWidth = 5;
        orientationLayout.marginHeight = 10;
        orientationGroup.setLayout((Layout)orientationLayout);
        gridData = new GridData(768, 128, false, false);
        gridData.verticalSpan = 2;
        gridData.widthHint = 150;
        gridData.heightHint = 60;
        orientationGroup.setLayoutData((Object)gridData);
        Button[] orientation = new Button[2];
        orientation[0] = new Button((Composite)orientationGroup, 16);
        orientation[0].setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Portrait"));
        orientation[0].setSelection(true);
        orientation[0].addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        orientation[1] = new Button((Composite)orientationGroup, 16);
        orientation[1].setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Landscape"));
        orientation[1].addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.previousButton = new Button((Composite)this.shell, 8);
        this.previousButton.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Previous"));
        this.previousButton.setEnabled(false);
        gridData = new GridData(131072, 128, true, false);
        gridData.widthHint = 100;
        this.previousButton.setLayoutData((Object)gridData);
        this.previousButton.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.nextButton = new Button((Composite)this.shell, 8);
        this.nextButton.setText(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Next"));
        this.nextButton.setEnabled(false);
        gridData = new GridData(16384, 128, false, false);
        gridData.widthHint = 100;
        this.nextButton.setLayoutData((Object)gridData);
        this.nextButton.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.pagesLabel = new Label((Composite)this.shell, 0);
        this.pagesLabel.setText(String.valueOf(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Page")) + " 1/1");
        gridData = new GridData(131072, 0x1000000, true, false);
        gridData.widthHint = 100;
        this.pagesLabel.setLayoutData((Object)gridData);
        this.shell.setSize(600, 500);
        this.shell.setMinimumSize(600, 500);
        this.shell.open();
        this.setPrinter(null, 1.0);
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    void setPrinter(Printer p_printer, double marginSize) {
        if (p_printer == null) {
            PrinterData[] list;
            PrinterData printerData = Printer.getDefaultPrinterData();
            if (printerData == null && (list = Printer.getPrinterList()).length > 0) {
                printerData = list[0];
            }
            this.printer = new Printer(printerData);
        } else {
            this.printer = p_printer;
        }
        this.margin = PrintMargin.getPrintMargin((Printer)this.printer, (double)marginSize);
        this.canvas.redraw();
    }

    void updateNavigation(int nbPagesX, int nbPagesY) {
        if (this.pageNavigation == null) {
            this.pageNavigation = new PrintPageNavigation(nbPagesX, nbPagesY);
            if (nbPagesX > 1 || nbPagesY > 1) {
                this.nextButton.setEnabled(true);
            }
        } else if (nbPagesX > 1 || nbPagesY > 1) {
            if (this.pageNavigation.getNbPagesX() != nbPagesX || this.pageNavigation.getNbPagesY() != nbPagesY) {
                this.pageNavigation.setNbPagesX(nbPagesX);
                this.pageNavigation.setNbPagesY(nbPagesY);
                this.pageNavigation.x = 1;
                this.pageNavigation.y = 1;
            }
            if (this.pageNavigation.isFirstPage()) {
                this.previousButton.setEnabled(false);
            } else {
                this.previousButton.setEnabled(true);
            }
            if (this.pageNavigation.isLastPage()) {
                this.nextButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(true);
            }
        } else {
            this.pageNavigation.x = 1;
            this.pageNavigation.y = 1;
            this.pageNavigation.setNbPagesX(1);
            this.pageNavigation.setNbPagesY(1);
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
        this.updatePageCounter();
    }

    void updatePageCounter() {
        this.pagesLabel.setText(String.valueOf(DiagramEditor.I18N.getString("Gui.PrintSetupDialog.Page")) + " " + this.pageNavigation.getCurrentPageNumber() + "/" + this.pageNavigation.getTotalPages());
    }
}

