/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.redrawlink;

import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.link.CreateBendedConnectionRequest;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Event;

public class RedrawConnectionTool
extends AbstractConnectionCreationTool {
    private StyleKey.ConnectionRouterId primaryRoutingMode = null;
    private StyleKey.ConnectionRouterId currentRoutingMode = null;
    private GmLink originalGmLink;
    private Point sourcePoint;
    private EditPart targetEditPart;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$diagram$styles$core$StyleKey$ConnectionRouterId;

    public RedrawConnectionTool(GmLinkEditPart linkEditPart) {
        super((CreationFactory)new ModelioLinkCreationContext(((GmLink)linkEditPart.getModel()).getRelatedIElement()));
        this.setUnloadWhenFinished(true);
        this.sourcePoint = ((Connection)linkEditPart.getFigure()).getSourceAnchor().getReferencePoint().getCopy();
        this.targetEditPart = linkEditPart.getTarget();
        this.originalGmLink = (GmLink)linkEditPart.getModel();
        this.originalGmLink.delete();
    }

    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        if (this.isInState(65)) {
            this.performViewerMouseWheel(event, viewer);
        }
    }

    boolean acceptConnectionFinish(KeyEvent event) {
        return this.isInState(32) && event.character == '\r';
    }

    boolean acceptConnectionStart(KeyEvent event) {
        return this.isInState(1) && event.character == '\r';
    }

    boolean navigateNextAnchor(int direction) {
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        AccessibleAnchorProvider provider = (AccessibleAnchorProvider)focus.getAdapter(AccessibleAnchorProvider.class);
        if (provider == null) {
            return false;
        }
        List list = this.isInState(32) ? provider.getTargetAnchorLocations() : provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        int i = 0;
        while (i < list.size()) {
            int d;
            Point p = (Point)list.get(i);
            if (!(p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance)) {
                distance = d;
                next = p;
            }
            ++i;
        }
        if (next != null) {
            this.placeMouseInViewer(next);
            return true;
        }
        return false;
    }

    protected Cursor calculateCursor() {
        if (this.isInState(0x40000000)) {
            return null;
        }
        Command command = this.getCurrentCommand();
        if (command == null || !command.canExecute()) {
            return this.getDisabledCursor();
        }
        return this.getDefaultCursor();
    }

    protected Request createTargetRequest() {
        CreateBendedConnectionRequest req = new CreateBendedConnectionRequest();
        req.setFactory(this.getFactory());
        req.setType((Object)"connection start");
        return req;
    }

    protected String getCommandName() {
        if (this.isInState(96)) {
            return "connection end";
        }
        return "connection start";
    }

    protected StyleKey.ConnectionRouterId getCurrentRoutingMode() {
        StyleKey routerKey;
        if (this.currentRoutingMode == null && (routerKey = this.originalGmLink.getStyleKey(MetaKey.CONNECTIONROUTER)) != null) {
            this.currentRoutingMode = (StyleKey.ConnectionRouterId)this.originalGmLink.getStyle().getProperty(routerKey);
        }
        if (this.currentRoutingMode == null) {
            this.currentRoutingMode = this.getPrimaryRoutingMode();
        }
        return this.currentRoutingMode;
    }

    protected CreateBendedConnectionRequest getTargetRequest() {
        return (CreateBendedConnectionRequest)super.getTargetRequest();
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.isInState(64)) {
            if (this.getTargetRequest().getType() == "add bendpoint to future connection" && this.handleCreateIntermediatePoint()) {
                return true;
            }
            if (this.handleCreateConnection()) {
                this.setState(0x40000000);
                return true;
            }
        }
        if (this.isInState(1) && button == 1) {
            super.handleButtonDown(button);
            if (this.getCurrentCommand() != null) {
                this.getTargetRequest().getData().setSrcPoint(this.getLocation());
            }
        } else {
            super.handleButtonDown(button);
        }
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(96)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    protected boolean handleKeyDown(KeyEvent event) {
        if (this.acceptArrowKey(event)) {
            int direction = 0;
            switch (event.keyCode) {
                case 0x1000002: {
                    direction = 4;
                    break;
                }
                case 0x1000001: {
                    direction = 1;
                    break;
                }
                case 0x1000004: {
                    direction = this.isCurrentViewerMirrored2() ? 8 : 16;
                    break;
                }
                case 0x1000003: {
                    direction = this.isCurrentViewerMirrored2() ? 16 : 8;
                }
            }
            boolean consumed = false;
            if (direction != 0 && event.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                event.stateMask |= 0x40000;
                event.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                    this.navigateNextAnchor(0);
                    this.updateTargetRequest();
                    this.updateTargetUnderMouse();
                    Command command = this.getCommand();
                    if (command != null) {
                        this.setCurrentCommand(command);
                    }
                    return true;
                }
            }
        }
        if (event.character == '/' || event.character == '\\') {
            event.stateMask |= 0x40000;
            if (this.getCurrentViewer().getKeyHandler().keyPressed(event)) {
                this.navigateNextAnchor(0);
                return true;
            }
        }
        if (this.acceptConnectionStart(event)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.updateTargetUnderMouse();
                this.setConnectionSource(this.getTargetEditPart());
                this.getTargetRequest().setSourceEditPart(this.getTargetEditPart());
                this.setState(32);
                this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
            }
            return true;
        }
        if (this.acceptConnectionFinish(event)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.setState(1);
                this.placeMouseInViewer(this.getLocation().getTranslated(6, 6));
                this.eraseSourceFeedback();
                this.eraseTargetFeedback();
                this.setCurrentCommand(command);
                this.executeCurrentCommand();
            }
            return true;
        }
        if (this.acceptSwapRoutingMode(event)) {
            this.swapRoutingMode();
            this.updateTargetRequest();
            this.showSourceFeedback();
            return true;
        }
        return super.handleKeyDown(event);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptSwapRoutingMode(e)) {
            this.swapRoutingMode();
            this.updateTargetRequest();
            this.showSourceFeedback();
            return true;
        }
        return super.handleKeyUp(e);
    }

    protected void updateTargetRequest() {
        CreateBendedConnectionRequest request = this.getTargetRequest();
        request.setLocation(this.getLocation());
        request.getData().setLastPoint(new Point(this.getLocation()));
        request.getData().setRoutingMode(this.getCurrentRoutingMode());
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            this.getTargetRequest().setType((Object)this.getCommandName());
            EditPart editPart = this.getTargetUnderMouse();
            if (editPart == null && this.isInState(64)) {
                this.getTargetRequest().setType((Object)"add bendpoint to future connection");
                editPart = this.getTargetUnderMouse();
            }
            return this.updateTargetEditPart(editPart);
        }
        return false;
    }

    private boolean acceptSwapRoutingMode(KeyEvent event) {
        return event.keyCode == 131072;
    }

    /*
     * Exception decompiling
     */
    private StyleKey.ConnectionRouterId getAlternateRoutingMode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StyleKey.ConnectionRouterId getPrimaryRoutingMode() {
        if (this.getFactory() instanceof ModelioLinkCreationContext) {
            ModelioLinkCreationContext ctx = (ModelioLinkCreationContext)this.getFactory();
            IGmObject gmDiagram = (IGmObject)this.getCurrentViewer().getContents().getModel();
            StyleKey routingModeKey = ctx.getDefaultRoutingModeKey();
            if (routingModeKey != null) {
                this.primaryRoutingMode = (StyleKey.ConnectionRouterId)gmDiagram.getStyle().getProperty(routingModeKey);
            }
        }
        if (this.primaryRoutingMode == null) {
            this.primaryRoutingMode = StyleKey.ConnectionRouterId.BENDPOINT;
        }
        return this.primaryRoutingMode;
    }

    private EditPart getTargetUnderMouse() {
        EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
        if (editPart != null) {
            editPart = editPart.getTargetEditPart((Request)this.getTargetRequest());
        }
        return editPart;
    }

    private boolean handleCreateIntermediatePoint() {
        Command endCommand = this.getCommand();
        if (endCommand != null) {
            CreateBendedConnectionRequest r = this.getTargetRequest();
            Point newPoint = r.getLocation();
            r.getData().getPath().add(newPoint);
            this.setCurrentCommand(endCommand);
            this.showSourceFeedback();
            return true;
        }
        return false;
    }

    private boolean isCurrentViewerMirrored2() {
        return (this.getCurrentViewer().getControl().getStyle() & 0x8000000) != 0;
    }

    private void swapRoutingMode() {
        this.currentRoutingMode = this.currentRoutingMode == this.getPrimaryRoutingMode() ? this.getAlternateRoutingMode() : this.getPrimaryRoutingMode();
    }

    private boolean updateTargetEditPart(EditPart editPart) {
        boolean changed = this.getTargetEditPart() != editPart;
        this.setTargetEditPart(editPart);
        return changed;
    }

    public void setViewer(EditPartViewer viewer) {
        EditPartViewer oldViewer = this.getCurrentViewer();
        super.setViewer(viewer);
        if (viewer != null && !viewer.equals(oldViewer)) {
            this.getCurrentInput().setMouseLocation(this.sourcePoint.x, this.sourcePoint.y);
            this.handleButtonDown(1);
            this.handleButtonUp(1);
        }
    }

    protected void showTargetFeedback() {
        super.showTargetFeedback();
        if (this.targetEditPart != null && ("add bendpoint to future connection".equals(this.getTargetRequest().getType()) || "connection end".equals(this.getTargetRequest().getType()))) {
            Object type = this.getTargetRequest().getType();
            this.getTargetRequest().setType((Object)"connection end");
            EditPart tmpEP = this.getTargetRequest().getTargetEditPart();
            this.getTargetRequest().setTargetEditPart(this.targetEditPart);
            this.targetEditPart.showTargetFeedback((Request)this.getTargetRequest());
            this.getTargetRequest().setTargetEditPart(tmpEP);
            this.getTargetRequest().setType(type);
        }
    }

    protected void eraseTargetFeedback() {
        super.eraseTargetFeedback();
        if (this.targetEditPart != null) {
            this.targetEditPart.eraseTargetFeedback((Request)this.getTargetRequest());
        }
    }

    protected boolean handleCreateConnection() {
        Command command = this.getCommand();
        boolean handled = command != null && command.canExecute();
        super.handleCreateConnection();
        return handled;
    }

    public void deactivate() {
        boolean mustReload = false;
        if (!this.isInState(0x40000000)) {
            mustReload = true;
        }
        super.deactivate();
        if (mustReload) {
            DiagramPersistence.loadDiagram((GmAbstractDiagram)this.originalGmLink.getDiagram());
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$diagram$styles$core$StyleKey$ConnectionRouterId() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$diagram$styles$core$StyleKey$ConnectionRouterId != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$diagram$styles$core$StyleKey$ConnectionRouterId;
        }
        int[] nArray = new int[StyleKey.ConnectionRouterId.values().length];
        try {
            nArray[StyleKey.ConnectionRouterId.BENDPOINT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StyleKey.ConnectionRouterId.DIRECT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StyleKey.ConnectionRouterId.ORTHOGONAL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$diagram$styles$core$StyleKey$ConnectionRouterId = nArray;
        return nArray;
    }
}

