/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.redrawlink;

import com.modeliosoft.modelio.diagram.editor.handlers.redrawlink.RedrawConnectionTool;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class RedrawLinkHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GmLinkEditPart primarySelection = null;
        for (GmLinkEditPart editPart : this.getLinksToProcess()) {
            if (editPart.getSelected() != 2) continue;
            primarySelection = editPart;
            break;
        }
        if (primarySelection != null) {
            EditDomain editDomain = primarySelection.getViewer().getEditDomain();
            RedrawConnectionTool redrawTool = new RedrawConnectionTool(primarySelection);
            editDomain.setActiveTool((Tool)redrawTool);
        }
        return null;
    }

    public boolean isEnabled() {
        List selectedLinks = this.getLinksToProcess();
        if (selectedLinks.isEmpty()) {
            return false;
        }
        for (GmLinkEditPart linkEditpart : selectedLinks) {
            GmLink link = (GmLink)linkEditpart.getModel();
            StyleKey styleKey = link.getStyleKey(MetaKey.CONNECTIONROUTER);
            if (styleKey == null) continue;
            return true;
        }
        return false;
    }

    protected List<GmLinkEditPart> getLinksToProcess() {
        ArrayList<GmLinkEditPart> selectedLinks = new ArrayList<GmLinkEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                if (!(selectedObject instanceof GmLinkEditPart)) continue;
                selectedLinks.add((GmLinkEditPart)selectedObject);
            }
        }
        return selectedLinks;
    }
}

