/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IActivityDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityParameterNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IInstanceNode;
import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehaviorParameter;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ActivityDiagramCreationContributor
implements IDiagramWizardContributor {
    private IActivityDiagram smartCreateForNameSpace(IModelingSession modelingSession, IActivity activity, String diagramName) {
        IActivityDiagram diagram = this.createActivityDiagram(modelingSession, diagramName, activity);
        if (diagram != null) {
            this.checkLocalCollaboration(modelingSession, activity);
        }
        return diagram;
    }

    private IActivityDiagram smartCreateForOperation(IModelingSession modelingSession, IActivity activity, IOperation parentOperation, String diagramName) {
        IActivityDiagram diagram = this.createActivityDiagram(modelingSession, diagramName, activity);
        if (diagram != null) {
            String parameterName;
            IBindableInstance instance;
            ICollaboration locals = this.checkLocalCollaboration(modelingSession, activity);
            if (locals != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
                instance.setName("this");
                instance.setBase((INameSpace)parentOperation.getOwner());
                IInstanceNode instanceNode = (IInstanceNode)modelingSession.getModel().createElement("InstanceNode", (IElement)activity, "OwnedNode");
                if (instanceNode != null) {
                    instanceNode.setName("this");
                    instanceNode.setRepresented((IInstance)instance);
                }
            }
            ObList paramsList = parentOperation.getIO();
            IBehaviorParameter behaviorParameter = null;
            IActivityParameterNode parameterNode = null;
            for (IParameter parameter : paramsList) {
                behaviorParameter = (IBehaviorParameter)modelingSession.getModel().createElement("BehaviorParameter", (IElement)activity, "Parameter");
                parameterName = parameter.getName();
                if (behaviorParameter == null) continue;
                behaviorParameter.setName(parameterName);
                behaviorParameter.setMultiplicityMin(parameter.getMultiplicityMin());
                behaviorParameter.setMultiplicityMax(parameter.getMultiplicityMax());
                behaviorParameter.setParameterPassing(parameter.getParameterPassing());
                behaviorParameter.setTypeConstraint(parameter.getTypeConstraint());
                behaviorParameter.setDefaultValue(parameter.getDefaultValue());
                behaviorParameter.setMapped(parameter);
                behaviorParameter.setType(parameter.getType());
                parameterNode = (IActivityParameterNode)modelingSession.getModel().createElement("ActivityParameterNode", (IElement)activity, "OwnedNode");
                if (parameterNode == null) continue;
                parameterNode.setRepresentedRealParameter(behaviorParameter);
                parameterNode.setName(parameterName);
            }
            IParameter returnParameter = parentOperation.getReturn();
            if (returnParameter != null) {
                behaviorParameter = (IBehaviorParameter)modelingSession.getModel().createElement("BehaviorParameter", (IElement)activity, "Parameter");
                parameterName = returnParameter.getName();
                if (behaviorParameter != null) {
                    behaviorParameter.setName(parameterName);
                    behaviorParameter.setMultiplicityMin(returnParameter.getMultiplicityMin());
                    behaviorParameter.setMultiplicityMax(returnParameter.getMultiplicityMax());
                    behaviorParameter.setParameterPassing(returnParameter.getParameterPassing());
                    behaviorParameter.setTypeConstraint(returnParameter.getTypeConstraint());
                    behaviorParameter.setDefaultValue(returnParameter.getDefaultValue());
                    behaviorParameter.setMapped(returnParameter);
                    behaviorParameter.setType(returnParameter.getType());
                    parameterNode = (IActivityParameterNode)modelingSession.getModel().createElement("ActivityParameterNode", (IElement)activity, "OwnedNode");
                    if (parameterNode != null) {
                        parameterNode.setRepresentedRealParameter(behaviorParameter);
                        parameterNode.setName(parameterName);
                    }
                }
            }
        }
        return diagram;
    }

    private IActivityDiagram smartCreateForClassifier(IModelingSession modelingSession, IActivity activity, INameSpace parentClassifier, String diagramName) {
        IBindableInstance instance;
        ICollaboration locals;
        IActivityDiagram diagram = this.createActivityDiagram(modelingSession, diagramName, activity);
        if (diagram != null && (locals = this.checkLocalCollaboration(modelingSession, activity)) != null && (instance = (IBindableInstance)modelingSession.getModel().createElement("BindableInstance", (IElement)locals, "Declared")) != null) {
            instance.setName("this");
            instance.setBase(parentClassifier);
            IInstanceNode instanceNode = (IInstanceNode)modelingSession.getModel().createElement("InstanceNode", (IElement)activity, "OwnedNode");
            if (instanceNode != null) {
                instanceNode.setName("this");
                instanceNode.setRepresented((IInstance)instance);
            }
        }
        return diagram;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        IActivityDiagram diagram = null;
        IActivity activity = null;
        if (diagramContext instanceof IActivity) {
            activity = (IActivity)diagramContext;
        } else {
            activity = (IActivity)modelingSession.getModel().createElement("Activity", (IElement)diagramContext, "OwnedBehavior");
            DefaultNameFactory.setDefaultName((IModelElement)activity);
        }
        if (activity != null && (diagram = diagramContext instanceof IClassifier && !(diagramContext instanceof IUseCase) ? this.smartCreateForClassifier(modelingSession, activity, (INameSpace)diagramContext, diagramName) : (diagramContext instanceof IOperation ? this.smartCreateForOperation(modelingSession, activity, (IOperation)diagramContext, diagramName) : this.smartCreateForNameSpace(modelingSession, activity, diagramName))) != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IInterface.class);
        allowedMetaclasses.add(ISignal.class);
        allowedMetaclasses.add(IActor.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IUseCase.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IOperation.class);
        allowedMetaclasses.add(IActivity.class);
        return allowedMetaclasses;
    }

    private IActivityDiagram createActivityDiagram(IModelingSession modelingSession, String diagramName, IActivity diagramContext) {
        IActivityDiagram diagram = modelingSession.getModel().createActivityDiagram(diagramName, (IModelElement)diagramContext);
        if (diagram != null) {
            diagram.setVertical(false);
        }
        return diagram;
    }

    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.Activity.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IActivityDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.Activity.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.Activity.Details");
    }

    protected ICollaboration checkLocalCollaboration(IModelingSession modelingSession, IActivity interaction) {
        ICollaboration locals = null;
        Iterator iterator = interaction.getOwnedCollaboration().iterator();
        if (iterator.hasNext()) {
            ICollaboration collab;
            locals = collab = (ICollaboration)iterator.next();
        }
        if (locals == null) {
            locals = (ICollaboration)modelingSession.getModel().createElement("Collaboration", (IElement)interaction, "OwnedCollaboration");
            locals.setName("locals");
        }
        return locals;
    }
}

