/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.handlers.umlwizard;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnBehavior;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnCollaboration;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcessCollaborationDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.ITemplateParameter;
import com.modeliosoft.modelio.api.model.uml.usecase.IActor;
import com.modeliosoft.modelio.api.model.uml.usecase.IUseCase;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.diagramcreation.IDiagramWizardContributor;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.diagram.editor.plugin.DiagramEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class BpmnProcessCollaborationDiagramCreationContributor
implements IDiagramWizardContributor {
    public boolean accept(IElement owner) {
        if (owner != null) {
            for (Class metaclass : this.getAllowedMetaclasses()) {
                if (!metaclass.isAssignableFrom(owner.getClass())) continue;
                IElementStatus elementStatus = owner.getElementStatus();
                return elementStatus.isCmsNode() || elementStatus.isModifiable();
            }
        }
        return false;
    }

    public IAbstractDiagram actionPerformed(IModelElement diagramContext, String diagramName, String diagramDescription) {
        IModelingSession modelingSession = Modelio.getInstance().getModelingSession();
        IBpmnProcess process = null;
        process = diagramContext instanceof IBpmnProcess ? (IBpmnProcess)diagramContext : this.createBpmnProcess(modelingSession, diagramContext);
        IBpmnProcessCollaborationDiagram diagram = this.createBPMNDiagram(modelingSession, process, diagramName);
        if (diagram != null) {
            try {
                diagram.putNoteContent("description", diagramDescription);
            }
            catch (NoteTypeNotFoundException e) {
                DiagramEditor.LOG.warning((Throwable)e);
            }
        }
        return diagram;
    }

    public List<Class<? extends IElement>> getAllowedMetaclasses() {
        ArrayList<Class<? extends IElement>> allowedMetaclasses = new ArrayList<Class<? extends IElement>>();
        allowedMetaclasses.add(IPackage.class);
        allowedMetaclasses.add(IClass.class);
        allowedMetaclasses.add(IInterface.class);
        allowedMetaclasses.add(ISignal.class);
        allowedMetaclasses.add(IActor.class);
        allowedMetaclasses.add(IComponent.class);
        allowedMetaclasses.add(INode.class);
        allowedMetaclasses.add(IUseCase.class);
        allowedMetaclasses.add(ICollaboration.class);
        allowedMetaclasses.add(IOperation.class);
        allowedMetaclasses.add(IBpmnProcess.class);
        allowedMetaclasses.add(IBpmnBehavior.class);
        return allowedMetaclasses;
    }

    private IBpmnProcessCollaborationDiagram createBPMNDiagram(IModelingSession modelingSession, IBpmnProcess owner, String diagramName) {
        IBpmnProcessCollaborationDiagram diagram = (IBpmnProcessCollaborationDiagram)modelingSession.getModel().createElement("BpmnProcessCollaborationDiagram");
        diagram.setOrigin((IModelElement)owner);
        diagram.setName(diagramName);
        return diagram;
    }

    private IBpmnProcess createBpmnProcess(IModelingSession modelingSession, IModelElement diagramContext) {
        IBpmnBehavior behavior = null;
        IBpmnProcess process = null;
        IBpmnCollaboration collaboration = null;
        if (diagramContext instanceof IBpmnBehavior) {
            behavior = (IBpmnBehavior)diagramContext;
        } else if (diagramContext instanceof INameSpace) {
            behavior = (IBpmnBehavior)modelingSession.getModel().createElement("BpmnBehavior");
            behavior.setOwner((INameSpace)diagramContext);
            DefaultNameFactory.setDefaultName((IModelElement)behavior);
        } else if (diagramContext instanceof IOperation) {
            behavior = (IBpmnBehavior)modelingSession.getModel().createElement("BpmnBehavior");
            behavior.setOwnerOperation((IOperation)diagramContext);
            DefaultNameFactory.setDefaultName((IModelElement)behavior);
        } else if (diagramContext instanceof ITemplateParameter) {
            behavior = (IBpmnBehavior)modelingSession.getModel().createElement("BpmnBehavior");
            behavior.setOwnerTemplateParameter((ITemplateParameter)diagramContext);
            DefaultNameFactory.setDefaultName((IModelElement)behavior);
        }
        if (behavior != null) {
            process = (IBpmnProcess)modelingSession.getModel().createElement("BpmnProcess");
            process.setOwner(behavior);
            DefaultNameFactory.setDefaultName((IModelElement)process);
            if (behavior.cardRootElement(IBpmnCollaboration.class) == 0) {
                collaboration = (IBpmnCollaboration)modelingSession.getModel().createElement("BpmnCollaboration");
                collaboration.setOwner(behavior);
                DefaultNameFactory.setDefaultName((IModelElement)collaboration);
            }
        }
        return process;
    }

    public String getCommandName() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnProcessCollaboration.Name");
    }

    public Image getImage() {
        return StandardImageService.getMetaclassImage(IBpmnProcessCollaborationDiagram.class);
    }

    public String getInformation() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnProcessCollaboration.Information");
    }

    public String getHelpUrl() {
        return null;
    }

    public String getDetails() {
        return DiagramEditor.I18N.getString("UmlWizard.BpmnProcessCollaboration.Details");
    }
}

